@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resource stage details.
 * @property displayName Display name of the resource stage.
 * @property stageName Stage name
 * @property stageStatus Stage status.
 * @property startTime Stage start time
 */
public data class StageDetailsResponse(
    public val displayName: String,
    public val stageName: String,
    public val stageStatus: String,
    public val startTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.StageDetailsResponse):
            StageDetailsResponse = StageDetailsResponse(
            displayName = javaType.displayName(),
            stageName = javaType.stageName(),
            stageStatus = javaType.stageStatus(),
            startTime = javaType.startTime(),
        )
    }
}
