@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.education.kotlin

import com.pulumi.azurenative.education.StudentArgs.builder
import com.pulumi.azurenative.education.kotlin.enums.StudentRole
import com.pulumi.azurenative.education.kotlin.inputs.AmountArgs
import com.pulumi.azurenative.education.kotlin.inputs.AmountArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Student details.
 * Azure REST API version: 2021-12-01-preview. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * ## Example Usage
 * ### Student
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var student = new AzureNative.Education.Student("student", new()
 *     {
 *         BillingAccountName = "{billingAccountName}",
 *         BillingProfileName = "{billingProfileName}",
 *         Budget = new AzureNative.Education.Inputs.AmountArgs
 *         {
 *             Currency = "USD",
 *             Value = 100,
 *         },
 *         Email = "test@contoso.com",
 *         ExpirationDate = "2021-11-09T22:13:21.795Z",
 *         FirstName = "test",
 *         InvoiceSectionName = "{invoiceSectionName}",
 *         LastName = "user",
 *         Role = AzureNative.Education.StudentRole.Student,
 *         StudentAlias = "{studentAlias}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/education/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := education.NewStudent(ctx, "student", &education.StudentArgs{
 * 			BillingAccountName: pulumi.String("{billingAccountName}"),
 * 			BillingProfileName: pulumi.String("{billingProfileName}"),
 * 			Budget: &education.AmountArgs{
 * 				Currency: pulumi.String("USD"),
 * 				Value:    pulumi.Float64(100),
 * 			},
 * 			Email:              pulumi.String("test@contoso.com"),
 * 			ExpirationDate:     pulumi.String("2021-11-09T22:13:21.795Z"),
 * 			FirstName:          pulumi.String("test"),
 * 			InvoiceSectionName: pulumi.String("{invoiceSectionName}"),
 * 			LastName:           pulumi.String("user"),
 * 			Role:               pulumi.String(education.StudentRoleStudent),
 * 			StudentAlias:       pulumi.String("{studentAlias}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.education.Student;
 * import com.pulumi.azurenative.education.StudentArgs;
 * import com.pulumi.azurenative.education.inputs.AmountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var student = new Student("student", StudentArgs.builder()
 *             .billingAccountName("{billingAccountName}")
 *             .billingProfileName("{billingProfileName}")
 *             .budget(AmountArgs.builder()
 *                 .currency("USD")
 *                 .value(100)
 *                 .build())
 *             .email("test@contoso.com")
 *             .expirationDate("2021-11-09T22:13:21.795Z")
 *             .firstName("test")
 *             .invoiceSectionName("{invoiceSectionName}")
 *             .lastName("user")
 *             .role("Student")
 *             .studentAlias("{studentAlias}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:education:Student {studentAlias} /providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs/default/students/{studentAlias}
 * ```
 * @property billingAccountName The ID that uniquely identifies a billing account.
 * @property billingProfileName The ID that uniquely identifies a billing profile.
 * @property budget Student Budget
 * @property email Student Email
 * @property expirationDate Date this student is set to expire from the lab.
 * @property firstName First Name
 * @property invoiceSectionName The ID that uniquely identifies an invoice section.
 * @property lastName Last Name
 * @property role Student Role
 * @property studentAlias Student alias.
 * @property subscriptionAlias Subscription alias
 * @property subscriptionInviteLastSentDate subscription invite last sent date
 */
public data class StudentArgs(
    public val billingAccountName: Output<String>? = null,
    public val billingProfileName: Output<String>? = null,
    public val budget: Output<AmountArgs>? = null,
    public val email: Output<String>? = null,
    public val expirationDate: Output<String>? = null,
    public val firstName: Output<String>? = null,
    public val invoiceSectionName: Output<String>? = null,
    public val lastName: Output<String>? = null,
    public val role: Output<Either<String, StudentRole>>? = null,
    public val studentAlias: Output<String>? = null,
    public val subscriptionAlias: Output<String>? = null,
    public val subscriptionInviteLastSentDate: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.education.StudentArgs> {
    override fun toJava(): com.pulumi.azurenative.education.StudentArgs =
        com.pulumi.azurenative.education.StudentArgs.builder()
            .billingAccountName(billingAccountName?.applyValue({ args0 -> args0 }))
            .billingProfileName(billingProfileName?.applyValue({ args0 -> args0 }))
            .budget(budget?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .email(email?.applyValue({ args0 -> args0 }))
            .expirationDate(expirationDate?.applyValue({ args0 -> args0 }))
            .firstName(firstName?.applyValue({ args0 -> args0 }))
            .invoiceSectionName(invoiceSectionName?.applyValue({ args0 -> args0 }))
            .lastName(lastName?.applyValue({ args0 -> args0 }))
            .role(
                role?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .studentAlias(studentAlias?.applyValue({ args0 -> args0 }))
            .subscriptionAlias(subscriptionAlias?.applyValue({ args0 -> args0 }))
            .subscriptionInviteLastSentDate(
                subscriptionInviteLastSentDate?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [StudentArgs].
 */
@PulumiTagMarker
public class StudentArgsBuilder internal constructor() {
    private var billingAccountName: Output<String>? = null

    private var billingProfileName: Output<String>? = null

    private var budget: Output<AmountArgs>? = null

    private var email: Output<String>? = null

    private var expirationDate: Output<String>? = null

    private var firstName: Output<String>? = null

    private var invoiceSectionName: Output<String>? = null

    private var lastName: Output<String>? = null

    private var role: Output<Either<String, StudentRole>>? = null

    private var studentAlias: Output<String>? = null

    private var subscriptionAlias: Output<String>? = null

    private var subscriptionInviteLastSentDate: Output<String>? = null

    /**
     * @param value The ID that uniquely identifies a billing account.
     */
    @JvmName("svevudvcrdnekkrv")
    public suspend fun billingAccountName(`value`: Output<String>) {
        this.billingAccountName = value
    }

    /**
     * @param value The ID that uniquely identifies a billing profile.
     */
    @JvmName("xnfscffmokstutxr")
    public suspend fun billingProfileName(`value`: Output<String>) {
        this.billingProfileName = value
    }

    /**
     * @param value Student Budget
     */
    @JvmName("snfkpkdmglipbxsx")
    public suspend fun budget(`value`: Output<AmountArgs>) {
        this.budget = value
    }

    /**
     * @param value Student Email
     */
    @JvmName("hciiwqcwwfwrcils")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value Date this student is set to expire from the lab.
     */
    @JvmName("wjdkvavwqslxnppd")
    public suspend fun expirationDate(`value`: Output<String>) {
        this.expirationDate = value
    }

    /**
     * @param value First Name
     */
    @JvmName("yugmajocjcnmjvcr")
    public suspend fun firstName(`value`: Output<String>) {
        this.firstName = value
    }

    /**
     * @param value The ID that uniquely identifies an invoice section.
     */
    @JvmName("yppwyubonchlvkru")
    public suspend fun invoiceSectionName(`value`: Output<String>) {
        this.invoiceSectionName = value
    }

    /**
     * @param value Last Name
     */
    @JvmName("xmsahevixilovquu")
    public suspend fun lastName(`value`: Output<String>) {
        this.lastName = value
    }

    /**
     * @param value Student Role
     */
    @JvmName("dnwqvoltngjvjftp")
    public suspend fun role(`value`: Output<Either<String, StudentRole>>) {
        this.role = value
    }

    /**
     * @param value Student alias.
     */
    @JvmName("sbiwxuqemdxdvsch")
    public suspend fun studentAlias(`value`: Output<String>) {
        this.studentAlias = value
    }

    /**
     * @param value Subscription alias
     */
    @JvmName("ysfwlurkpyhtqmsq")
    public suspend fun subscriptionAlias(`value`: Output<String>) {
        this.subscriptionAlias = value
    }

    /**
     * @param value subscription invite last sent date
     */
    @JvmName("hrqatsocllfiqpkl")
    public suspend fun subscriptionInviteLastSentDate(`value`: Output<String>) {
        this.subscriptionInviteLastSentDate = value
    }

    /**
     * @param value The ID that uniquely identifies a billing account.
     */
    @JvmName("qyqctffecpjgdfxb")
    public suspend fun billingAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingAccountName = mapped
    }

    /**
     * @param value The ID that uniquely identifies a billing profile.
     */
    @JvmName("ollfypqstvgbefac")
    public suspend fun billingProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingProfileName = mapped
    }

    /**
     * @param value Student Budget
     */
    @JvmName("durmdvadhydxsmcs")
    public suspend fun budget(`value`: AmountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.budget = mapped
    }

    /**
     * @param argument Student Budget
     */
    @JvmName("duttmcdvnofesupg")
    public suspend fun budget(argument: suspend AmountArgsBuilder.() -> Unit) {
        val toBeMapped = AmountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.budget = mapped
    }

    /**
     * @param value Student Email
     */
    @JvmName("drhmrbpeqpwuefib")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value Date this student is set to expire from the lab.
     */
    @JvmName("yobksmmeevycisxq")
    public suspend fun expirationDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationDate = mapped
    }

    /**
     * @param value First Name
     */
    @JvmName("ldbhabnogjplvpeu")
    public suspend fun firstName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstName = mapped
    }

    /**
     * @param value The ID that uniquely identifies an invoice section.
     */
    @JvmName("clmnmvtrlmktuxve")
    public suspend fun invoiceSectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invoiceSectionName = mapped
    }

    /**
     * @param value Last Name
     */
    @JvmName("dyiljrakregogoyk")
    public suspend fun lastName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastName = mapped
    }

    /**
     * @param value Student Role
     */
    @JvmName("ssjvvffscuhagcij")
    public suspend fun role(`value`: Either<String, StudentRole>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Student Role
     */
    @JvmName("uaptnbkcfxicdoem")
    public fun role(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StudentRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Student Role
     */
    @JvmName("kvmbcphkxrmxuxmx")
    public fun role(`value`: StudentRole) {
        val toBeMapped = Either.ofRight<String, StudentRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Student alias.
     */
    @JvmName("ncvrxefbgdhkjugs")
    public suspend fun studentAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.studentAlias = mapped
    }

    /**
     * @param value Subscription alias
     */
    @JvmName("vcbtiwisbvvhuoop")
    public suspend fun subscriptionAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionAlias = mapped
    }

    /**
     * @param value subscription invite last sent date
     */
    @JvmName("hqqjapjrmntdclxr")
    public suspend fun subscriptionInviteLastSentDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionInviteLastSentDate = mapped
    }

    internal fun build(): StudentArgs = StudentArgs(
        billingAccountName = billingAccountName,
        billingProfileName = billingProfileName,
        budget = budget,
        email = email,
        expirationDate = expirationDate,
        firstName = firstName,
        invoiceSectionName = invoiceSectionName,
        lastName = lastName,
        role = role,
        studentAlias = studentAlias,
        subscriptionAlias = subscriptionAlias,
        subscriptionInviteLastSentDate = subscriptionInviteLastSentDate,
    )
}
