@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.education.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Lab details.
 * @property budgetPerStudent Default monetary cap for each student in this lab
 * @property currency The type of currency being used for the value.
 * @property description Detail description of this lab
 * @property displayName Lab Display Name
 * @property effectiveDate Lab creation date
 * @property expirationDate Default expiration date for each student in this lab
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property invitationCode invitation code for redeemable lab
 * @property maxStudentCount the total number of students that can be accepted to the lab.
 * @property name The name of the resource
 * @property status The status of this lab
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property value Amount value.
 */
public data class GetLabResult(
    public val budgetPerStudent: AmountResponse,
    public val currency: String? = null,
    public val description: String,
    public val displayName: String,
    public val effectiveDate: String,
    public val expirationDate: String,
    public val id: String,
    public val invitationCode: String,
    public val maxStudentCount: Double,
    public val name: String,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val `value`: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.education.outputs.GetLabResult):
            GetLabResult = GetLabResult(
            budgetPerStudent = javaType.budgetPerStudent().let({ args0 ->
                com.pulumi.azurenative.education.kotlin.outputs.AmountResponse.Companion.toKotlin(args0)
            }),
            currency = javaType.currency().map({ args0 -> args0 }).orElse(null),
            description = javaType.description(),
            displayName = javaType.displayName(),
            effectiveDate = javaType.effectiveDate(),
            expirationDate = javaType.expirationDate(),
            id = javaType.id(),
            invitationCode = javaType.invitationCode(),
            maxStudentCount = javaType.maxStudentCount(),
            name = javaType.name(),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.education.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
