@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin

import com.pulumi.azurenative.elastic.ElasticFunctions.getBillingInfoPlain
import com.pulumi.azurenative.elastic.ElasticFunctions.getMonitorPlain
import com.pulumi.azurenative.elastic.ElasticFunctions.getOpenAIPlain
import com.pulumi.azurenative.elastic.ElasticFunctions.getOpenAIStatusPlain
import com.pulumi.azurenative.elastic.ElasticFunctions.getOrganizationApiKeyPlain
import com.pulumi.azurenative.elastic.ElasticFunctions.getOrganizationElasticToAzureSubscriptionMappingPlain
import com.pulumi.azurenative.elastic.ElasticFunctions.getTagRulePlain
import com.pulumi.azurenative.elastic.ElasticFunctions.listAllTrafficFilterPlain
import com.pulumi.azurenative.elastic.ElasticFunctions.listConnectedPartnerResourcePlain
import com.pulumi.azurenative.elastic.ElasticFunctions.listDeploymentInfoPlain
import com.pulumi.azurenative.elastic.ElasticFunctions.listMonitoredResourcePlain
import com.pulumi.azurenative.elastic.ElasticFunctions.listUpgradableVersionDetailsPlain
import com.pulumi.azurenative.elastic.ElasticFunctions.listVMHostPlain
import com.pulumi.azurenative.elastic.ElasticFunctions.listlistAssociatedTrafficFilterPlain
import com.pulumi.azurenative.elastic.kotlin.inputs.GetBillingInfoPlainArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.GetBillingInfoPlainArgsBuilder
import com.pulumi.azurenative.elastic.kotlin.inputs.GetMonitorPlainArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.GetMonitorPlainArgsBuilder
import com.pulumi.azurenative.elastic.kotlin.inputs.GetOpenAIPlainArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.GetOpenAIPlainArgsBuilder
import com.pulumi.azurenative.elastic.kotlin.inputs.GetOpenAIStatusPlainArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.GetOpenAIStatusPlainArgsBuilder
import com.pulumi.azurenative.elastic.kotlin.inputs.GetOrganizationApiKeyPlainArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.GetOrganizationApiKeyPlainArgsBuilder
import com.pulumi.azurenative.elastic.kotlin.inputs.GetTagRulePlainArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.GetTagRulePlainArgsBuilder
import com.pulumi.azurenative.elastic.kotlin.inputs.ListAllTrafficFilterPlainArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.ListAllTrafficFilterPlainArgsBuilder
import com.pulumi.azurenative.elastic.kotlin.inputs.ListConnectedPartnerResourcePlainArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.ListConnectedPartnerResourcePlainArgsBuilder
import com.pulumi.azurenative.elastic.kotlin.inputs.ListDeploymentInfoPlainArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.ListDeploymentInfoPlainArgsBuilder
import com.pulumi.azurenative.elastic.kotlin.inputs.ListMonitoredResourcePlainArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.ListMonitoredResourcePlainArgsBuilder
import com.pulumi.azurenative.elastic.kotlin.inputs.ListUpgradableVersionDetailsPlainArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.ListUpgradableVersionDetailsPlainArgsBuilder
import com.pulumi.azurenative.elastic.kotlin.inputs.ListVMHostPlainArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.ListVMHostPlainArgsBuilder
import com.pulumi.azurenative.elastic.kotlin.inputs.ListlistAssociatedTrafficFilterPlainArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.ListlistAssociatedTrafficFilterPlainArgsBuilder
import com.pulumi.azurenative.elastic.kotlin.outputs.GetBillingInfoResult
import com.pulumi.azurenative.elastic.kotlin.outputs.GetMonitorResult
import com.pulumi.azurenative.elastic.kotlin.outputs.GetOpenAIResult
import com.pulumi.azurenative.elastic.kotlin.outputs.GetOpenAIStatusResult
import com.pulumi.azurenative.elastic.kotlin.outputs.GetOrganizationApiKeyResult
import com.pulumi.azurenative.elastic.kotlin.outputs.GetOrganizationElasticToAzureSubscriptionMappingResult
import com.pulumi.azurenative.elastic.kotlin.outputs.GetTagRuleResult
import com.pulumi.azurenative.elastic.kotlin.outputs.ListAllTrafficFilterResult
import com.pulumi.azurenative.elastic.kotlin.outputs.ListConnectedPartnerResourceResult
import com.pulumi.azurenative.elastic.kotlin.outputs.ListDeploymentInfoResult
import com.pulumi.azurenative.elastic.kotlin.outputs.ListMonitoredResourceResult
import com.pulumi.azurenative.elastic.kotlin.outputs.ListUpgradableVersionDetailsResult
import com.pulumi.azurenative.elastic.kotlin.outputs.ListVMHostResult
import com.pulumi.azurenative.elastic.kotlin.outputs.ListlistAssociatedTrafficFilterResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.elastic.kotlin.outputs.GetBillingInfoResult.Companion.toKotlin as getBillingInfoResultToKotlin
import com.pulumi.azurenative.elastic.kotlin.outputs.GetMonitorResult.Companion.toKotlin as getMonitorResultToKotlin
import com.pulumi.azurenative.elastic.kotlin.outputs.GetOpenAIResult.Companion.toKotlin as getOpenAIResultToKotlin
import com.pulumi.azurenative.elastic.kotlin.outputs.GetOpenAIStatusResult.Companion.toKotlin as getOpenAIStatusResultToKotlin
import com.pulumi.azurenative.elastic.kotlin.outputs.GetOrganizationApiKeyResult.Companion.toKotlin as getOrganizationApiKeyResultToKotlin
import com.pulumi.azurenative.elastic.kotlin.outputs.GetOrganizationElasticToAzureSubscriptionMappingResult.Companion.toKotlin as getOrganizationElasticToAzureSubscriptionMappingResultToKotlin
import com.pulumi.azurenative.elastic.kotlin.outputs.GetTagRuleResult.Companion.toKotlin as getTagRuleResultToKotlin
import com.pulumi.azurenative.elastic.kotlin.outputs.ListAllTrafficFilterResult.Companion.toKotlin as listAllTrafficFilterResultToKotlin
import com.pulumi.azurenative.elastic.kotlin.outputs.ListConnectedPartnerResourceResult.Companion.toKotlin as listConnectedPartnerResourceResultToKotlin
import com.pulumi.azurenative.elastic.kotlin.outputs.ListDeploymentInfoResult.Companion.toKotlin as listDeploymentInfoResultToKotlin
import com.pulumi.azurenative.elastic.kotlin.outputs.ListMonitoredResourceResult.Companion.toKotlin as listMonitoredResourceResultToKotlin
import com.pulumi.azurenative.elastic.kotlin.outputs.ListUpgradableVersionDetailsResult.Companion.toKotlin as listUpgradableVersionDetailsResultToKotlin
import com.pulumi.azurenative.elastic.kotlin.outputs.ListVMHostResult.Companion.toKotlin as listVMHostResultToKotlin
import com.pulumi.azurenative.elastic.kotlin.outputs.ListlistAssociatedTrafficFilterResult.Companion.toKotlin as listlistAssociatedTrafficFilterResultToKotlin

public object ElasticFunctions {
    /**
     * Marketplace Subscription and Organization details to which resource gets billed into.
     * Azure REST API version: 2023-07-01-preview.
     * Other available API versions: 2023-10-01-preview, 2023-11-01-preview, 2024-01-01-preview, 2024-03-01.
     * @param argument null
     * @return Marketplace Subscription and Organization details to which resource gets billed into.
     */
    public suspend fun getBillingInfo(argument: GetBillingInfoPlainArgs): GetBillingInfoResult =
        getBillingInfoResultToKotlin(getBillingInfoPlain(argument.toJava()).await())

    /**
     * @see [getBillingInfo].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Marketplace Subscription and Organization details to which resource gets billed into.
     */
    public suspend fun getBillingInfo(monitorName: String, resourceGroupName: String):
        GetBillingInfoResult {
        val argument = GetBillingInfoPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return getBillingInfoResultToKotlin(getBillingInfoPlain(argument.toJava()).await())
    }

    /**
     * @see [getBillingInfo].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elastic&#46;kotlin&#46;inputs&#46;GetBillingInfoPlainArgs].
     * @return Marketplace Subscription and Organization details to which resource gets billed into.
     */
    public suspend fun getBillingInfo(argument: suspend GetBillingInfoPlainArgsBuilder.() -> Unit):
        GetBillingInfoResult {
        val builder = GetBillingInfoPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBillingInfoResultToKotlin(getBillingInfoPlain(builtArgument.toJava()).await())
    }

    /**
     * Monitor resource.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2023-06-15-preview, 2023-07-01-preview, 2023-10-01-preview, 2023-11-01-preview, 2024-01-01-preview, 2024-03-01.
     * @param argument null
     * @return Monitor resource.
     */
    public suspend fun getMonitor(argument: GetMonitorPlainArgs): GetMonitorResult =
        getMonitorResultToKotlin(getMonitorPlain(argument.toJava()).await())

    /**
     * @see [getMonitor].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group to which the Elastic resource belongs.
     * @return Monitor resource.
     */
    public suspend fun getMonitor(monitorName: String, resourceGroupName: String): GetMonitorResult {
        val argument = GetMonitorPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return getMonitorResultToKotlin(getMonitorPlain(argument.toJava()).await())
    }

    /**
     * @see [getMonitor].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elastic&#46;kotlin&#46;inputs&#46;GetMonitorPlainArgs].
     * @return Monitor resource.
     */
    public suspend fun getMonitor(argument: suspend GetMonitorPlainArgsBuilder.() -> Unit):
        GetMonitorResult {
        val builder = GetMonitorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMonitorResultToKotlin(getMonitorPlain(builtArgument.toJava()).await())
    }

    /**
     * Capture properties of Open AI resource Integration.
     * Azure REST API version: 2024-03-01.
     * Other available API versions: 2024-01-01-preview.
     * @param argument null
     * @return Capture properties of Open AI resource Integration.
     */
    public suspend fun getOpenAI(argument: GetOpenAIPlainArgs): GetOpenAIResult =
        getOpenAIResultToKotlin(getOpenAIPlain(argument.toJava()).await())

    /**
     * @see [getOpenAI].
     * @param integrationName OpenAI Integration name
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Capture properties of Open AI resource Integration.
     */
    public suspend fun getOpenAI(
        integrationName: String,
        monitorName: String,
        resourceGroupName: String,
    ): GetOpenAIResult {
        val argument = GetOpenAIPlainArgs(
            integrationName = integrationName,
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return getOpenAIResultToKotlin(getOpenAIPlain(argument.toJava()).await())
    }

    /**
     * @see [getOpenAI].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elastic&#46;kotlin&#46;inputs&#46;GetOpenAIPlainArgs].
     * @return Capture properties of Open AI resource Integration.
     */
    public suspend fun getOpenAI(argument: suspend GetOpenAIPlainArgsBuilder.() -> Unit):
        GetOpenAIResult {
        val builder = GetOpenAIPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOpenAIResultToKotlin(getOpenAIPlain(builtArgument.toJava()).await())
    }

    /**
     * Status of the OpenAI Integration
     * Azure REST API version: 2024-03-01.
     * Other available API versions: 2024-01-01-preview.
     * @param argument null
     * @return Status of the OpenAI Integration
     */
    public suspend fun getOpenAIStatus(argument: GetOpenAIStatusPlainArgs): GetOpenAIStatusResult =
        getOpenAIStatusResultToKotlin(getOpenAIStatusPlain(argument.toJava()).await())

    /**
     * @see [getOpenAIStatus].
     * @param integrationName OpenAI Integration name
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Status of the OpenAI Integration
     */
    public suspend fun getOpenAIStatus(
        integrationName: String,
        monitorName: String,
        resourceGroupName: String,
    ): GetOpenAIStatusResult {
        val argument = GetOpenAIStatusPlainArgs(
            integrationName = integrationName,
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return getOpenAIStatusResultToKotlin(getOpenAIStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getOpenAIStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elastic&#46;kotlin&#46;inputs&#46;GetOpenAIStatusPlainArgs].
     * @return Status of the OpenAI Integration
     */
    public suspend fun getOpenAIStatus(argument: suspend GetOpenAIStatusPlainArgsBuilder.() -> Unit):
        GetOpenAIStatusResult {
        val builder = GetOpenAIStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOpenAIStatusResultToKotlin(getOpenAIStatusPlain(builtArgument.toJava()).await())
    }

    /**
     * Fetch User API Key from internal database, if it was generated and stored while creating the Elasticsearch Organization.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2023-02-01-preview, 2023-05-01-preview, 2023-06-15-preview, 2023-07-01-preview, 2023-10-01-preview, 2023-11-01-preview, 2024-01-01-preview, 2024-03-01.
     * @param argument null
     * @return The User Api Key created for the Organization associated with the User Email Id that was passed in the request
     */
    public suspend fun getOrganizationApiKey(argument: GetOrganizationApiKeyPlainArgs):
        GetOrganizationApiKeyResult =
        getOrganizationApiKeyResultToKotlin(getOrganizationApiKeyPlain(argument.toJava()).await())

    /**
     * @see [getOrganizationApiKey].
     * @param emailId The User email Id
     * @return The User Api Key created for the Organization associated with the User Email Id that was passed in the request
     */
    public suspend fun getOrganizationApiKey(emailId: String? = null): GetOrganizationApiKeyResult {
        val argument = GetOrganizationApiKeyPlainArgs(
            emailId = emailId,
        )
        return getOrganizationApiKeyResultToKotlin(getOrganizationApiKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getOrganizationApiKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elastic&#46;kotlin&#46;inputs&#46;GetOrganizationApiKeyPlainArgs].
     * @return The User Api Key created for the Organization associated with the User Email Id that was passed in the request
     */
    public suspend
    fun getOrganizationApiKey(argument: suspend GetOrganizationApiKeyPlainArgsBuilder.() -> Unit):
        GetOrganizationApiKeyResult {
        val builder = GetOrganizationApiKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrganizationApiKeyResultToKotlin(getOrganizationApiKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get Elastic Organization To Azure Subscription Mapping details for the logged-in user.
     * Azure REST API version: 2023-06-15-preview.
     * Other available API versions: 2023-07-01-preview, 2023-10-01-preview, 2023-11-01-preview, 2024-01-01-preview, 2024-03-01.
     * @param argument null
     * @return The Azure Subscription ID to which the Organization of the logged in user belongs and gets billed into.
     */
    public suspend fun getOrganizationElasticToAzureSubscriptionMapping():
        GetOrganizationElasticToAzureSubscriptionMappingResult =
        getOrganizationElasticToAzureSubscriptionMappingResultToKotlin(getOrganizationElasticToAzureSubscriptionMappingPlain().await())

    /**
     * Capture logs and metrics of Azure resources based on ARM tags.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2023-06-15-preview, 2023-07-01-preview, 2023-10-01-preview, 2023-11-01-preview, 2024-01-01-preview, 2024-03-01.
     * @param argument null
     * @return Capture logs and metrics of Azure resources based on ARM tags.
     */
    public suspend fun getTagRule(argument: GetTagRulePlainArgs): GetTagRuleResult =
        getTagRuleResultToKotlin(getTagRulePlain(argument.toJava()).await())

    /**
     * @see [getTagRule].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group to which the Elastic resource belongs.
     * @param ruleSetName Tag Rule Set resource name
     * @return Capture logs and metrics of Azure resources based on ARM tags.
     */
    public suspend fun getTagRule(
        monitorName: String,
        resourceGroupName: String,
        ruleSetName: String,
    ): GetTagRuleResult {
        val argument = GetTagRulePlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
            ruleSetName = ruleSetName,
        )
        return getTagRuleResultToKotlin(getTagRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getTagRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elastic&#46;kotlin&#46;inputs&#46;GetTagRulePlainArgs].
     * @return Capture logs and metrics of Azure resources based on ARM tags.
     */
    public suspend fun getTagRule(argument: suspend GetTagRulePlainArgsBuilder.() -> Unit):
        GetTagRuleResult {
        val builder = GetTagRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTagRuleResultToKotlin(getTagRulePlain(builtArgument.toJava()).await())
    }

    /**
     * List of elastic traffic filters in the account
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2023-06-15-preview, 2023-07-01-preview, 2023-10-01-preview, 2023-11-01-preview, 2024-01-01-preview, 2024-03-01.
     * @param argument null
     * @return List of elastic traffic filters in the account
     */
    public suspend fun listAllTrafficFilter(argument: ListAllTrafficFilterPlainArgs):
        ListAllTrafficFilterResult =
        listAllTrafficFilterResultToKotlin(listAllTrafficFilterPlain(argument.toJava()).await())

    /**
     * @see [listAllTrafficFilter].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group to which the Elastic resource belongs.
     * @return List of elastic traffic filters in the account
     */
    public suspend fun listAllTrafficFilter(monitorName: String, resourceGroupName: String):
        ListAllTrafficFilterResult {
        val argument = ListAllTrafficFilterPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return listAllTrafficFilterResultToKotlin(listAllTrafficFilterPlain(argument.toJava()).await())
    }

    /**
     * @see [listAllTrafficFilter].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elastic&#46;kotlin&#46;inputs&#46;ListAllTrafficFilterPlainArgs].
     * @return List of elastic traffic filters in the account
     */
    public suspend
    fun listAllTrafficFilter(argument: suspend ListAllTrafficFilterPlainArgsBuilder.() -> Unit):
        ListAllTrafficFilterResult {
        val builder = ListAllTrafficFilterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAllTrafficFilterResultToKotlin(listAllTrafficFilterPlain(builtArgument.toJava()).await())
    }

    /**
     *  List of all active elastic deployments.
     * Azure REST API version: 2023-07-01-preview.
     * Other available API versions: 2023-10-01-preview, 2023-11-01-preview, 2024-01-01-preview, 2024-03-01.
     * @param argument null
     * @return List of all active elastic deployments.
     */
    public suspend fun listConnectedPartnerResource(argument: ListConnectedPartnerResourcePlainArgs):
        ListConnectedPartnerResourceResult =
        listConnectedPartnerResourceResultToKotlin(listConnectedPartnerResourcePlain(argument.toJava()).await())

    /**
     * @see [listConnectedPartnerResource].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return List of all active elastic deployments.
     */
    public suspend fun listConnectedPartnerResource(monitorName: String, resourceGroupName: String):
        ListConnectedPartnerResourceResult {
        val argument = ListConnectedPartnerResourcePlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return listConnectedPartnerResourceResultToKotlin(listConnectedPartnerResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [listConnectedPartnerResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elastic&#46;kotlin&#46;inputs&#46;ListConnectedPartnerResourcePlainArgs].
     * @return List of all active elastic deployments.
     */
    public suspend
    fun listConnectedPartnerResource(argument: suspend ListConnectedPartnerResourcePlainArgsBuilder.() -> Unit):
        ListConnectedPartnerResourceResult {
        val builder = ListConnectedPartnerResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listConnectedPartnerResourceResultToKotlin(listConnectedPartnerResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * The properties of deployment in Elastic cloud corresponding to the Elastic monitor resource.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2023-06-15-preview, 2023-07-01-preview, 2023-10-01-preview, 2023-11-01-preview, 2024-01-01-preview, 2024-03-01.
     * @param argument null
     * @return The properties of deployment in Elastic cloud corresponding to the Elastic monitor resource.
     */
    public suspend fun listDeploymentInfo(argument: ListDeploymentInfoPlainArgs):
        ListDeploymentInfoResult =
        listDeploymentInfoResultToKotlin(listDeploymentInfoPlain(argument.toJava()).await())

    /**
     * @see [listDeploymentInfo].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group to which the Elastic resource belongs.
     * @return The properties of deployment in Elastic cloud corresponding to the Elastic monitor resource.
     */
    public suspend fun listDeploymentInfo(monitorName: String, resourceGroupName: String):
        ListDeploymentInfoResult {
        val argument = ListDeploymentInfoPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return listDeploymentInfoResultToKotlin(listDeploymentInfoPlain(argument.toJava()).await())
    }

    /**
     * @see [listDeploymentInfo].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elastic&#46;kotlin&#46;inputs&#46;ListDeploymentInfoPlainArgs].
     * @return The properties of deployment in Elastic cloud corresponding to the Elastic monitor resource.
     */
    public suspend
    fun listDeploymentInfo(argument: suspend ListDeploymentInfoPlainArgsBuilder.() -> Unit):
        ListDeploymentInfoResult {
        val builder = ListDeploymentInfoPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDeploymentInfoResultToKotlin(listDeploymentInfoPlain(builtArgument.toJava()).await())
    }

    /**
     * Response of a list operation.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2023-06-15-preview, 2023-07-01-preview, 2023-10-01-preview, 2023-11-01-preview, 2024-01-01-preview, 2024-03-01.
     * @param argument null
     * @return Response of a list operation.
     */
    public suspend fun listMonitoredResource(argument: ListMonitoredResourcePlainArgs):
        ListMonitoredResourceResult =
        listMonitoredResourceResultToKotlin(listMonitoredResourcePlain(argument.toJava()).await())

    /**
     * @see [listMonitoredResource].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group to which the Elastic resource belongs.
     * @return Response of a list operation.
     */
    public suspend fun listMonitoredResource(monitorName: String, resourceGroupName: String):
        ListMonitoredResourceResult {
        val argument = ListMonitoredResourcePlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return listMonitoredResourceResultToKotlin(listMonitoredResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [listMonitoredResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elastic&#46;kotlin&#46;inputs&#46;ListMonitoredResourcePlainArgs].
     * @return Response of a list operation.
     */
    public suspend
    fun listMonitoredResource(argument: suspend ListMonitoredResourcePlainArgsBuilder.() -> Unit):
        ListMonitoredResourceResult {
        val builder = ListMonitoredResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listMonitoredResourceResultToKotlin(listMonitoredResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Stack Versions that this version can upgrade to
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2023-06-15-preview, 2023-07-01-preview, 2023-10-01-preview, 2023-11-01-preview, 2024-01-01-preview, 2024-03-01.
     * @param argument null
     * @return Stack Versions that this version can upgrade to
     */
    public suspend fun listUpgradableVersionDetails(argument: ListUpgradableVersionDetailsPlainArgs):
        ListUpgradableVersionDetailsResult =
        listUpgradableVersionDetailsResultToKotlin(listUpgradableVersionDetailsPlain(argument.toJava()).await())

    /**
     * @see [listUpgradableVersionDetails].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group to which the Elastic resource belongs.
     * @return Stack Versions that this version can upgrade to
     */
    public suspend fun listUpgradableVersionDetails(monitorName: String, resourceGroupName: String):
        ListUpgradableVersionDetailsResult {
        val argument = ListUpgradableVersionDetailsPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return listUpgradableVersionDetailsResultToKotlin(listUpgradableVersionDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [listUpgradableVersionDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elastic&#46;kotlin&#46;inputs&#46;ListUpgradableVersionDetailsPlainArgs].
     * @return Stack Versions that this version can upgrade to
     */
    public suspend
    fun listUpgradableVersionDetails(argument: suspend ListUpgradableVersionDetailsPlainArgsBuilder.() -> Unit):
        ListUpgradableVersionDetailsResult {
        val builder = ListUpgradableVersionDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listUpgradableVersionDetailsResultToKotlin(listUpgradableVersionDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Response of a list operation.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2023-06-15-preview, 2023-07-01-preview, 2023-10-01-preview, 2023-11-01-preview, 2024-01-01-preview, 2024-03-01.
     * @param argument null
     * @return Response of a list operation.
     */
    public suspend fun listVMHost(argument: ListVMHostPlainArgs): ListVMHostResult =
        listVMHostResultToKotlin(listVMHostPlain(argument.toJava()).await())

    /**
     * @see [listVMHost].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group to which the Elastic resource belongs.
     * @return Response of a list operation.
     */
    public suspend fun listVMHost(monitorName: String, resourceGroupName: String): ListVMHostResult {
        val argument = ListVMHostPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return listVMHostResultToKotlin(listVMHostPlain(argument.toJava()).await())
    }

    /**
     * @see [listVMHost].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elastic&#46;kotlin&#46;inputs&#46;ListVMHostPlainArgs].
     * @return Response of a list operation.
     */
    public suspend fun listVMHost(argument: suspend ListVMHostPlainArgsBuilder.() -> Unit):
        ListVMHostResult {
        val builder = ListVMHostPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listVMHostResultToKotlin(listVMHostPlain(builtArgument.toJava()).await())
    }

    /**
     * List of elastic traffic filters in the account
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2023-06-15-preview, 2023-07-01-preview, 2023-10-01-preview, 2023-11-01-preview, 2024-01-01-preview, 2024-03-01.
     * @param argument null
     * @return List of elastic traffic filters in the account
     */
    public suspend
    fun listlistAssociatedTrafficFilter(argument: ListlistAssociatedTrafficFilterPlainArgs):
        ListlistAssociatedTrafficFilterResult =
        listlistAssociatedTrafficFilterResultToKotlin(listlistAssociatedTrafficFilterPlain(argument.toJava()).await())

    /**
     * @see [listlistAssociatedTrafficFilter].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group to which the Elastic resource belongs.
     * @return List of elastic traffic filters in the account
     */
    public suspend fun listlistAssociatedTrafficFilter(
        monitorName: String,
        resourceGroupName: String,
    ): ListlistAssociatedTrafficFilterResult {
        val argument = ListlistAssociatedTrafficFilterPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return listlistAssociatedTrafficFilterResultToKotlin(listlistAssociatedTrafficFilterPlain(argument.toJava()).await())
    }

    /**
     * @see [listlistAssociatedTrafficFilter].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elastic&#46;kotlin&#46;inputs&#46;ListlistAssociatedTrafficFilterPlainArgs].
     * @return List of elastic traffic filters in the account
     */
    public suspend
    fun listlistAssociatedTrafficFilter(argument: suspend ListlistAssociatedTrafficFilterPlainArgsBuilder.() -> Unit):
        ListlistAssociatedTrafficFilterResult {
        val builder = ListlistAssociatedTrafficFilterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listlistAssociatedTrafficFilterResultToKotlin(listlistAssociatedTrafficFilterPlain(builtArgument.toJava()).await())
    }
}
