@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.inputs

import com.pulumi.azurenative.elastic.inputs.CompanyInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Company information of the user to be passed to partners.
 * @property business Business of the company
 * @property country Country of the company location.
 * @property domain Domain of the company
 * @property employeesNumber Number of employees in the company
 * @property state State of the company location.
 */
public data class CompanyInfoArgs(
    public val business: Output<String>? = null,
    public val country: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val employeesNumber: Output<String>? = null,
    public val state: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.inputs.CompanyInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.elastic.inputs.CompanyInfoArgs =
        com.pulumi.azurenative.elastic.inputs.CompanyInfoArgs.builder()
            .business(business?.applyValue({ args0 -> args0 }))
            .country(country?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .employeesNumber(employeesNumber?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CompanyInfoArgs].
 */
@PulumiTagMarker
public class CompanyInfoArgsBuilder internal constructor() {
    private var business: Output<String>? = null

    private var country: Output<String>? = null

    private var domain: Output<String>? = null

    private var employeesNumber: Output<String>? = null

    private var state: Output<String>? = null

    /**
     * @param value Business of the company
     */
    @JvmName("yqhmkuygbvsvaubw")
    public suspend fun business(`value`: Output<String>) {
        this.business = value
    }

    /**
     * @param value Country of the company location.
     */
    @JvmName("qpmvcnwrbqrwtfqe")
    public suspend fun country(`value`: Output<String>) {
        this.country = value
    }

    /**
     * @param value Domain of the company
     */
    @JvmName("uxxpxpiokgfxnvhh")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value Number of employees in the company
     */
    @JvmName("dcodwnorqbeyxqfb")
    public suspend fun employeesNumber(`value`: Output<String>) {
        this.employeesNumber = value
    }

    /**
     * @param value State of the company location.
     */
    @JvmName("hlooavpcrgnswedj")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value Business of the company
     */
    @JvmName("lhuwsprisdyxctsh")
    public suspend fun business(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.business = mapped
    }

    /**
     * @param value Country of the company location.
     */
    @JvmName("gbauuuwellxiidcl")
    public suspend fun country(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.country = mapped
    }

    /**
     * @param value Domain of the company
     */
    @JvmName("okswmypcbbytoeqv")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value Number of employees in the company
     */
    @JvmName("gdfqmjmwenhwhgue")
    public suspend fun employeesNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.employeesNumber = mapped
    }

    /**
     * @param value State of the company location.
     */
    @JvmName("ytlobuswmlhaheka")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): CompanyInfoArgs = CompanyInfoArgs(
        business = business,
        country = country,
        domain = domain,
        employeesNumber = employeesNumber,
        state = state,
    )
}
