@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.inputs

import com.pulumi.azurenative.elastic.inputs.GetOpenAIStatusPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property integrationName OpenAI Integration name
 * @property monitorName Monitor resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetOpenAIStatusPlainArgs(
    public val integrationName: String,
    public val monitorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.inputs.GetOpenAIStatusPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.elastic.inputs.GetOpenAIStatusPlainArgs =
        com.pulumi.azurenative.elastic.inputs.GetOpenAIStatusPlainArgs.builder()
            .integrationName(integrationName.let({ args0 -> args0 }))
            .monitorName(monitorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOpenAIStatusPlainArgs].
 */
@PulumiTagMarker
public class GetOpenAIStatusPlainArgsBuilder internal constructor() {
    private var integrationName: String? = null

    private var monitorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value OpenAI Integration name
     */
    @JvmName("qpckyfrbuyngvigc")
    public suspend fun integrationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationName = mapped
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("gopxcvhossqsoidx")
    public suspend fun monitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.monitorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yifwsistbyhavuif")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetOpenAIStatusPlainArgs = GetOpenAIStatusPlainArgs(
        integrationName = integrationName ?: throw PulumiNullFieldException("integrationName"),
        monitorName = monitorName ?: throw PulumiNullFieldException("monitorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
