@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.inputs

import com.pulumi.azurenative.elastic.inputs.GetTagRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property monitorName Monitor resource name
 * @property resourceGroupName The name of the resource group to which the Elastic resource belongs.
 * @property ruleSetName Tag Rule Set resource name
 */
public data class GetTagRulePlainArgs(
    public val monitorName: String,
    public val resourceGroupName: String,
    public val ruleSetName: String,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.inputs.GetTagRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.elastic.inputs.GetTagRulePlainArgs =
        com.pulumi.azurenative.elastic.inputs.GetTagRulePlainArgs.builder()
            .monitorName(monitorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleSetName(ruleSetName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTagRulePlainArgs].
 */
@PulumiTagMarker
public class GetTagRulePlainArgsBuilder internal constructor() {
    private var monitorName: String? = null

    private var resourceGroupName: String? = null

    private var ruleSetName: String? = null

    /**
     * @param value Monitor resource name
     */
    @JvmName("durlsjdnyabtntay")
    public suspend fun monitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.monitorName = mapped
    }

    /**
     * @param value The name of the resource group to which the Elastic resource belongs.
     */
    @JvmName("yeqwgtlktyqiqqlr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tag Rule Set resource name
     */
    @JvmName("fxyxvkqceglxnlpo")
    public suspend fun ruleSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleSetName = mapped
    }

    internal fun build(): GetTagRulePlainArgs = GetTagRulePlainArgs(
        monitorName = monitorName ?: throw PulumiNullFieldException("monitorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        ruleSetName = ruleSetName ?: throw PulumiNullFieldException("ruleSetName"),
    )
}
