@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.inputs

import com.pulumi.azurenative.elastic.inputs.LogRulesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Set of rules for sending logs for the Monitor resource.
 * @property filteringTags List of filtering tags to be used for capturing logs. This only takes effect if SendActivityLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
 * @property sendAadLogs Flag specifying if AAD logs should be sent for the Monitor resource.
 * @property sendActivityLogs Flag specifying if activity logs from Azure resources should be sent for the Monitor resource.
 * @property sendSubscriptionLogs Flag specifying if subscription logs should be sent for the Monitor resource.
 */
public data class LogRulesArgs(
    public val filteringTags: Output<List<FilteringTagArgs>>? = null,
    public val sendAadLogs: Output<Boolean>? = null,
    public val sendActivityLogs: Output<Boolean>? = null,
    public val sendSubscriptionLogs: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.inputs.LogRulesArgs> {
    override fun toJava(): com.pulumi.azurenative.elastic.inputs.LogRulesArgs =
        com.pulumi.azurenative.elastic.inputs.LogRulesArgs.builder()
            .filteringTags(
                filteringTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sendAadLogs(sendAadLogs?.applyValue({ args0 -> args0 }))
            .sendActivityLogs(sendActivityLogs?.applyValue({ args0 -> args0 }))
            .sendSubscriptionLogs(sendSubscriptionLogs?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogRulesArgs].
 */
@PulumiTagMarker
public class LogRulesArgsBuilder internal constructor() {
    private var filteringTags: Output<List<FilteringTagArgs>>? = null

    private var sendAadLogs: Output<Boolean>? = null

    private var sendActivityLogs: Output<Boolean>? = null

    private var sendSubscriptionLogs: Output<Boolean>? = null

    /**
     * @param value List of filtering tags to be used for capturing logs. This only takes effect if SendActivityLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("tutqkvscofhegbey")
    public suspend fun filteringTags(`value`: Output<List<FilteringTagArgs>>) {
        this.filteringTags = value
    }

    @JvmName("cgjhbixpnccjftfb")
    public suspend fun filteringTags(vararg values: Output<FilteringTagArgs>) {
        this.filteringTags = Output.all(values.asList())
    }

    /**
     * @param values List of filtering tags to be used for capturing logs. This only takes effect if SendActivityLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("fawypowfdnecajcs")
    public suspend fun filteringTags(values: List<Output<FilteringTagArgs>>) {
        this.filteringTags = Output.all(values)
    }

    /**
     * @param value Flag specifying if AAD logs should be sent for the Monitor resource.
     */
    @JvmName("heyspgseriekaxfx")
    public suspend fun sendAadLogs(`value`: Output<Boolean>) {
        this.sendAadLogs = value
    }

    /**
     * @param value Flag specifying if activity logs from Azure resources should be sent for the Monitor resource.
     */
    @JvmName("bbngosulbddvetvi")
    public suspend fun sendActivityLogs(`value`: Output<Boolean>) {
        this.sendActivityLogs = value
    }

    /**
     * @param value Flag specifying if subscription logs should be sent for the Monitor resource.
     */
    @JvmName("qgnsbrvgqwfkbphl")
    public suspend fun sendSubscriptionLogs(`value`: Output<Boolean>) {
        this.sendSubscriptionLogs = value
    }

    /**
     * @param value List of filtering tags to be used for capturing logs. This only takes effect if SendActivityLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("mgbhqmuuqidwmoom")
    public suspend fun filteringTags(`value`: List<FilteringTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filteringTags = mapped
    }

    /**
     * @param argument List of filtering tags to be used for capturing logs. This only takes effect if SendActivityLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("haifaaupadtatchr")
    public suspend fun filteringTags(argument: List<suspend FilteringTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FilteringTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filteringTags = mapped
    }

    /**
     * @param argument List of filtering tags to be used for capturing logs. This only takes effect if SendActivityLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("xufadwxvcmeqtyem")
    public suspend fun filteringTags(vararg argument: suspend FilteringTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FilteringTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filteringTags = mapped
    }

    /**
     * @param argument List of filtering tags to be used for capturing logs. This only takes effect if SendActivityLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("lehtnsconwfktslp")
    public suspend fun filteringTags(argument: suspend FilteringTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FilteringTagArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.filteringTags = mapped
    }

    /**
     * @param values List of filtering tags to be used for capturing logs. This only takes effect if SendActivityLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
     */
    @JvmName("lftvjtmycqvpspvg")
    public suspend fun filteringTags(vararg values: FilteringTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filteringTags = mapped
    }

    /**
     * @param value Flag specifying if AAD logs should be sent for the Monitor resource.
     */
    @JvmName("yqumhvctvjjintbx")
    public suspend fun sendAadLogs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendAadLogs = mapped
    }

    /**
     * @param value Flag specifying if activity logs from Azure resources should be sent for the Monitor resource.
     */
    @JvmName("hliuwconektypgdh")
    public suspend fun sendActivityLogs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendActivityLogs = mapped
    }

    /**
     * @param value Flag specifying if subscription logs should be sent for the Monitor resource.
     */
    @JvmName("bvtiouncglulaxuu")
    public suspend fun sendSubscriptionLogs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendSubscriptionLogs = mapped
    }

    internal fun build(): LogRulesArgs = LogRulesArgs(
        filteringTags = filteringTags,
        sendAadLogs = sendAadLogs,
        sendActivityLogs = sendActivityLogs,
        sendSubscriptionLogs = sendSubscriptionLogs,
    )
}
