@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.inputs

import com.pulumi.azurenative.elastic.inputs.MonitorPropertiesArgs.builder
import com.pulumi.azurenative.elastic.kotlin.enums.MonitoringStatus
import com.pulumi.azurenative.elastic.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties specific to the monitor resource.
 * @property generateApiKey Flag to determine if User API Key has to be generated and shared.
 * @property monitoringStatus Flag specifying if the resource monitoring is enabled or disabled.
 * @property provisioningState Provisioning state of the monitor resource.
 * @property userInfo User information.
 * @property version Version of elastic of the monitor resource
 */
public data class MonitorPropertiesArgs(
    public val generateApiKey: Output<Boolean>? = null,
    public val monitoringStatus: Output<Either<String, MonitoringStatus>>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val userInfo: Output<UserInfoArgs>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.inputs.MonitorPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.elastic.inputs.MonitorPropertiesArgs =
        com.pulumi.azurenative.elastic.inputs.MonitorPropertiesArgs.builder()
            .generateApiKey(generateApiKey?.applyValue({ args0 -> args0 }))
            .monitoringStatus(
                monitoringStatus?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .userInfo(userInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitorPropertiesArgs].
 */
@PulumiTagMarker
public class MonitorPropertiesArgsBuilder internal constructor() {
    private var generateApiKey: Output<Boolean>? = null

    private var monitoringStatus: Output<Either<String, MonitoringStatus>>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var userInfo: Output<UserInfoArgs>? = null

    private var version: Output<String>? = null

    /**
     * @param value Flag to determine if User API Key has to be generated and shared.
     */
    @JvmName("mvqatreaylhussxb")
    public suspend fun generateApiKey(`value`: Output<Boolean>) {
        this.generateApiKey = value
    }

    /**
     * @param value Flag specifying if the resource monitoring is enabled or disabled.
     */
    @JvmName("mhocyowxierktalp")
    public suspend fun monitoringStatus(`value`: Output<Either<String, MonitoringStatus>>) {
        this.monitoringStatus = value
    }

    /**
     * @param value Provisioning state of the monitor resource.
     */
    @JvmName("kgjdclyquloshbmx")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value User information.
     */
    @JvmName("esssmikveikdcuyx")
    public suspend fun userInfo(`value`: Output<UserInfoArgs>) {
        this.userInfo = value
    }

    /**
     * @param value Version of elastic of the monitor resource
     */
    @JvmName("jwjfwthyqvtpgjac")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Flag to determine if User API Key has to be generated and shared.
     */
    @JvmName("ldcjhgisrkndicnn")
    public suspend fun generateApiKey(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.generateApiKey = mapped
    }

    /**
     * @param value Flag specifying if the resource monitoring is enabled or disabled.
     */
    @JvmName("dokmjfbodjyaqsvp")
    public suspend fun monitoringStatus(`value`: Either<String, MonitoringStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringStatus = mapped
    }

    /**
     * @param value Flag specifying if the resource monitoring is enabled or disabled.
     */
    @JvmName("gcojttfhruiwfbfy")
    public fun monitoringStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MonitoringStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitoringStatus = mapped
    }

    /**
     * @param value Flag specifying if the resource monitoring is enabled or disabled.
     */
    @JvmName("puxttwsvlfxknhdn")
    public fun monitoringStatus(`value`: MonitoringStatus) {
        val toBeMapped = Either.ofRight<String, MonitoringStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitoringStatus = mapped
    }

    /**
     * @param value Provisioning state of the monitor resource.
     */
    @JvmName("eghmdmcsnunfijbo")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the monitor resource.
     */
    @JvmName("dknkhpttgluidwxu")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the monitor resource.
     */
    @JvmName("nodskllawtnmswks")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value User information.
     */
    @JvmName("aavsrdcehgdphyye")
    public suspend fun userInfo(`value`: UserInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userInfo = mapped
    }

    /**
     * @param argument User information.
     */
    @JvmName("oaiekwbffnlhwjtk")
    public suspend fun userInfo(argument: suspend UserInfoArgsBuilder.() -> Unit) {
        val toBeMapped = UserInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userInfo = mapped
    }

    /**
     * @param value Version of elastic of the monitor resource
     */
    @JvmName("ycdoxxygsagfahjj")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): MonitorPropertiesArgs = MonitorPropertiesArgs(
        generateApiKey = generateApiKey,
        monitoringStatus = monitoringStatus,
        provisioningState = provisioningState,
        userInfo = userInfo,
        version = version,
    )
}
