@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.inputs

import com.pulumi.azurenative.elastic.inputs.OpenAIIntegrationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Open AI Integration details.
 * @property key Value of API key for Open AI resource
 */
public data class OpenAIIntegrationPropertiesArgs(
    public val key: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.inputs.OpenAIIntegrationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.elastic.inputs.OpenAIIntegrationPropertiesArgs =
        com.pulumi.azurenative.elastic.inputs.OpenAIIntegrationPropertiesArgs.builder()
            .key(key?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenAIIntegrationPropertiesArgs].
 */
@PulumiTagMarker
public class OpenAIIntegrationPropertiesArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    /**
     * @param value Value of API key for Open AI resource
     */
    @JvmName("lyfpwekyywegoomk")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Value of API key for Open AI resource
     */
    @JvmName("excvdnuusjsjnidb")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    internal fun build(): OpenAIIntegrationPropertiesArgs = OpenAIIntegrationPropertiesArgs(
        key = key,
    )
}
