@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.inputs

import com.pulumi.azurenative.elastic.inputs.UserInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * User Information to be passed to partners.
 * @property companyInfo Company information of the user to be passed to partners.
 * @property companyName Company name of the user
 * @property emailAddress Email of the user used by Elastic for contacting them if needed
 * @property firstName First name of the user
 * @property lastName Last name of the user
 */
public data class UserInfoArgs(
    public val companyInfo: Output<CompanyInfoArgs>? = null,
    public val companyName: Output<String>? = null,
    public val emailAddress: Output<String>? = null,
    public val firstName: Output<String>? = null,
    public val lastName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.inputs.UserInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.elastic.inputs.UserInfoArgs =
        com.pulumi.azurenative.elastic.inputs.UserInfoArgs.builder()
            .companyInfo(companyInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .companyName(companyName?.applyValue({ args0 -> args0 }))
            .emailAddress(emailAddress?.applyValue({ args0 -> args0 }))
            .firstName(firstName?.applyValue({ args0 -> args0 }))
            .lastName(lastName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserInfoArgs].
 */
@PulumiTagMarker
public class UserInfoArgsBuilder internal constructor() {
    private var companyInfo: Output<CompanyInfoArgs>? = null

    private var companyName: Output<String>? = null

    private var emailAddress: Output<String>? = null

    private var firstName: Output<String>? = null

    private var lastName: Output<String>? = null

    /**
     * @param value Company information of the user to be passed to partners.
     */
    @JvmName("mtletgqufokjlnsx")
    public suspend fun companyInfo(`value`: Output<CompanyInfoArgs>) {
        this.companyInfo = value
    }

    /**
     * @param value Company name of the user
     */
    @JvmName("cfkcmtwnexptysla")
    public suspend fun companyName(`value`: Output<String>) {
        this.companyName = value
    }

    /**
     * @param value Email of the user used by Elastic for contacting them if needed
     */
    @JvmName("skgnqcohpsrbcnex")
    public suspend fun emailAddress(`value`: Output<String>) {
        this.emailAddress = value
    }

    /**
     * @param value First name of the user
     */
    @JvmName("dxedckntmhyqaqtq")
    public suspend fun firstName(`value`: Output<String>) {
        this.firstName = value
    }

    /**
     * @param value Last name of the user
     */
    @JvmName("hrgpddwrrxwqxtwp")
    public suspend fun lastName(`value`: Output<String>) {
        this.lastName = value
    }

    /**
     * @param value Company information of the user to be passed to partners.
     */
    @JvmName("abqtdtalitytnlrj")
    public suspend fun companyInfo(`value`: CompanyInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.companyInfo = mapped
    }

    /**
     * @param argument Company information of the user to be passed to partners.
     */
    @JvmName("brxdixoojaibpjqs")
    public suspend fun companyInfo(argument: suspend CompanyInfoArgsBuilder.() -> Unit) {
        val toBeMapped = CompanyInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.companyInfo = mapped
    }

    /**
     * @param value Company name of the user
     */
    @JvmName("nfxmfeghxcvapxtw")
    public suspend fun companyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.companyName = mapped
    }

    /**
     * @param value Email of the user used by Elastic for contacting them if needed
     */
    @JvmName("vtfeqjhnlgleuppc")
    public suspend fun emailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAddress = mapped
    }

    /**
     * @param value First name of the user
     */
    @JvmName("utfpbipargrxrvnr")
    public suspend fun firstName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstName = mapped
    }

    /**
     * @param value Last name of the user
     */
    @JvmName("hwxgosktuyjjpadf")
    public suspend fun lastName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastName = mapped
    }

    internal fun build(): UserInfoArgs = UserInfoArgs(
        companyInfo = companyInfo,
        companyName = companyName,
        emailAddress = emailAddress,
        firstName = firstName,
        lastName = lastName,
    )
}
