@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Stack Versions that this version can upgrade to
 * @property currentVersion Current version of the elastic monitor
 * @property upgradableVersions Stack Versions that this version can upgrade to
 */
public data class ListUpgradableVersionDetailsResult(
    public val currentVersion: String? = null,
    public val upgradableVersions: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.ListUpgradableVersionDetailsResult):
            ListUpgradableVersionDetailsResult = ListUpgradableVersionDetailsResult(
            currentVersion = javaType.currentVersion().map({ args0 -> args0 }).orElse(null),
            upgradableVersions = javaType.upgradableVersions().map({ args0 -> args0 }),
        )
    }
}
