@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Open AI Integration details.
 * @property key Value of API key for Open AI resource
 * @property lastRefreshAt Last Update Timestamp for key updation
 * @property openAIResourceEndpoint The API endpoint for Open AI resource
 * @property openAIResourceId The resource id of Open AI resource
 */
public data class OpenAIIntegrationPropertiesResponse(
    public val key: String? = null,
    public val lastRefreshAt: String,
    public val openAIResourceEndpoint: String,
    public val openAIResourceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.OpenAIIntegrationPropertiesResponse):
            OpenAIIntegrationPropertiesResponse = OpenAIIntegrationPropertiesResponse(
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            lastRefreshAt = javaType.lastRefreshAt(),
            openAIResourceEndpoint = javaType.openAIResourceEndpoint(),
            openAIResourceId = javaType.openAIResourceId(),
        )
    }
}
