@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The vm resource properties that is currently being monitored by the Elastic monitor resource.
 * @property vmResourceId The ARM id of the VM resource.
 */
public data class VMResourcesResponse(
    public val vmResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.VMResourcesResponse):
            VMResourcesResponse = VMResourcesResponse(
            vmResourceId = javaType.vmResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
