@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin

import com.pulumi.azurenative.elasticsan.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.elasticsan.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.elasticsan.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.elasticsan.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ElasticSan].
 */
@PulumiTagMarker
public class ElasticSanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ElasticSanArgs = ElasticSanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ElasticSanArgsBuilder.() -> Unit) {
        val builder = ElasticSanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ElasticSan {
        val builtJavaResource = com.pulumi.azurenative.elasticsan.ElasticSan(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ElasticSan(builtJavaResource)
    }
}

/**
 * Response for ElasticSan request.
 * Azure REST API version: 2021-11-20-preview. Prior API version in Azure Native 1.x: 2021-11-20-preview.
 * Other available API versions: 2022-12-01-preview, 2023-01-01.
 * ## Example Usage
 * ### ElasticSans_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var elasticSan = new AzureNative.ElasticSan.ElasticSan("elasticSan", new()
 *     {
 *         AvailabilityZones = new[]
 *         {
 *             "aaaaaaaaaaaaaaaaa",
 *         },
 *         BaseSizeTiB = 26,
 *         ElasticSanName = "ti7q-k952-1qB3J_5",
 *         ExtendedCapacitySizeTiB = 7,
 *         Location = "aaaaaaaaaaaaaaaaaaaaaaaaaaa",
 *         ResourceGroupName = "rgelasticsan",
 *         Sku = new AzureNative.ElasticSan.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.ElasticSan.SkuName.Premium_LRS,
 *             Tier = AzureNative.ElasticSan.SkuTier.Premium,
 *         },
 *         Tags =
 *         {
 *             { "key896", "aaaaaaaaaaaaaaaaaa" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewElasticSan(ctx, "elasticSan", &elasticsan.ElasticSanArgs{
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("aaaaaaaaaaaaaaaaa"),
 * 			},
 * 			BaseSizeTiB:             pulumi.Float64(26),
 * 			ElasticSanName:          pulumi.String("ti7q-k952-1qB3J_5"),
 * 			ExtendedCapacitySizeTiB: pulumi.Float64(7),
 * 			Location:                pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 * 			ResourceGroupName:       pulumi.String("rgelasticsan"),
 * 			Sku: &elasticsan.SkuArgs{
 * 				Name: pulumi.String(elasticsan.SkuName_Premium_LRS),
 * 				Tier: pulumi.String(elasticsan.SkuTierPremium),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key896": pulumi.String("aaaaaaaaaaaaaaaaaa"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.ElasticSan;
 * import com.pulumi.azurenative.elasticsan.ElasticSanArgs;
 * import com.pulumi.azurenative.elasticsan.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var elasticSan = new ElasticSan("elasticSan", ElasticSanArgs.builder()
 *             .availabilityZones("aaaaaaaaaaaaaaaaa")
 *             .baseSizeTiB(26)
 *             .elasticSanName("ti7q-k952-1qB3J_5")
 *             .extendedCapacitySizeTiB(7)
 *             .location("aaaaaaaaaaaaaaaaaaaaaaaaaaa")
 *             .resourceGroupName("rgelasticsan")
 *             .sku(SkuArgs.builder()
 *                 .name("Premium_LRS")
 *                 .tier("Premium")
 *                 .build())
 *             .tags(Map.of("key896", "aaaaaaaaaaaaaaaaaa"))
 *             .build());
 *     }
 * }
 * ```
 * ### ElasticSans_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var elasticSan = new AzureNative.ElasticSan.ElasticSan("elasticSan", new()
 *     {
 *         BaseSizeTiB = 26,
 *         ElasticSanName = "ti7q-k952-1qB3J_5",
 *         ExtendedCapacitySizeTiB = 7,
 *         ResourceGroupName = "rgelasticsan",
 *         Sku = new AzureNative.ElasticSan.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.ElasticSan.SkuName.Premium_LRS,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewElasticSan(ctx, "elasticSan", &elasticsan.ElasticSanArgs{
 * 			BaseSizeTiB:             pulumi.Float64(26),
 * 			ElasticSanName:          pulumi.String("ti7q-k952-1qB3J_5"),
 * 			ExtendedCapacitySizeTiB: pulumi.Float64(7),
 * 			ResourceGroupName:       pulumi.String("rgelasticsan"),
 * 			Sku: &elasticsan.SkuArgs{
 * 				Name: pulumi.String(elasticsan.SkuName_Premium_LRS),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.ElasticSan;
 * import com.pulumi.azurenative.elasticsan.ElasticSanArgs;
 * import com.pulumi.azurenative.elasticsan.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var elasticSan = new ElasticSan("elasticSan", ElasticSanArgs.builder()
 *             .baseSizeTiB(26)
 *             .elasticSanName("ti7q-k952-1qB3J_5")
 *             .extendedCapacitySizeTiB(7)
 *             .resourceGroupName("rgelasticsan")
 *             .sku(SkuArgs.builder()
 *                 .name("Premium_LRS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:elasticsan:ElasticSan aaaaaaaaaaa /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}
 * ```
 */
public class ElasticSan internal constructor(
    override val javaResource: com.pulumi.azurenative.elasticsan.ElasticSan,
) : KotlinCustomResource(javaResource, ElasticSanMapper) {
    /**
     * Logical zone for Elastic San resource; example: ["1"].
     */
    public val availabilityZones: Output<List<String>>?
        get() = javaResource.availabilityZones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Base size of the Elastic San appliance in TiB.
     */
    public val baseSizeTiB: Output<Double>
        get() = javaResource.baseSizeTiB().applyValue({ args0 -> args0 })

    /**
     * Extended size of the Elastic San appliance in TiB.
     */
    public val extendedCapacitySizeTiB: Output<Double>
        get() = javaResource.extendedCapacitySizeTiB().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of the operation on the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * resource sku
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * Resource metadata required by ARM RPC
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Azure resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Total Provisioned IOPS of the Elastic San appliance.
     */
    public val totalIops: Output<Double>
        get() = javaResource.totalIops().applyValue({ args0 -> args0 })

    /**
     * Total Provisioned MBps Elastic San appliance.
     */
    public val totalMBps: Output<Double>
        get() = javaResource.totalMBps().applyValue({ args0 -> args0 })

    /**
     * Total size of the Elastic San appliance in TB.
     */
    public val totalSizeTiB: Output<Double>
        get() = javaResource.totalSizeTiB().applyValue({ args0 -> args0 })

    /**
     * Total size of the provisioned Volumes in GiB.
     */
    public val totalVolumeSizeGiB: Output<Double>
        get() = javaResource.totalVolumeSizeGiB().applyValue({ args0 -> args0 })

    /**
     * Azure resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Total number of volume groups in this Elastic San appliance.
     */
    public val volumeGroupCount: Output<Double>
        get() = javaResource.volumeGroupCount().applyValue({ args0 -> args0 })
}

public object ElasticSanMapper : ResourceMapper<ElasticSan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.elasticsan.ElasticSan::class == javaResource::class

    override fun map(javaResource: Resource): ElasticSan = ElasticSan(
        javaResource as
            com.pulumi.azurenative.elasticsan.ElasticSan,
    )
}

/**
 * @see [ElasticSan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ElasticSan].
 */
public suspend fun elasticSan(name: String, block: suspend ElasticSanResourceBuilder.() -> Unit):
    ElasticSan {
    val builder = ElasticSanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ElasticSan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun elasticSan(name: String): ElasticSan {
    val builder = ElasticSanResourceBuilder()
    builder.name(name)
    return builder.build()
}
