@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin

import com.pulumi.azurenative.elasticsan.kotlin.outputs.NetworkRuleSetResponse
import com.pulumi.azurenative.elasticsan.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.elasticsan.kotlin.outputs.NetworkRuleSetResponse.Companion.toKotlin as networkRuleSetResponseToKotlin
import com.pulumi.azurenative.elasticsan.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [VolumeGroup].
 */
@PulumiTagMarker
public class VolumeGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VolumeGroupArgs = VolumeGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VolumeGroupArgsBuilder.() -> Unit) {
        val builder = VolumeGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VolumeGroup {
        val builtJavaResource = com.pulumi.azurenative.elasticsan.VolumeGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VolumeGroup(builtJavaResource)
    }
}

/**
 * Response for Volume Group request.
 * Azure REST API version: 2021-11-20-preview. Prior API version in Azure Native 1.x: 2021-11-20-preview.
 * Other available API versions: 2022-12-01-preview, 2023-01-01.
 * ## Example Usage
 * ### VolumeGroups_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volumeGroup = new AzureNative.ElasticSan.VolumeGroup("volumeGroup", new()
 *     {
 *         ElasticSanName = "ti7q-k952-1qB3J_5",
 *         Encryption = AzureNative.ElasticSan.EncryptionType.EncryptionAtRestWithPlatformKey,
 *         NetworkAcls = new AzureNative.ElasticSan.Inputs.NetworkRuleSetArgs
 *         {
 *             VirtualNetworkRules = new[]
 *             {
 *                 new AzureNative.ElasticSan.Inputs.VirtualNetworkRuleArgs
 *                 {
 *                     Action = AzureNative.ElasticSan.Action.Allow,
 *                     VirtualNetworkResourceId = "aaaaaaaaaaaaaaaa",
 *                 },
 *             },
 *         },
 *         ProtocolType = AzureNative.ElasticSan.StorageTargetType.Iscsi,
 *         ResourceGroupName = "rgelasticsan",
 *         Tags =
 *         {
 *             { "key5933", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaa" },
 *         },
 *         VolumeGroupName = "u_5I_1j4t3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewVolumeGroup(ctx, "volumeGroup", &elasticsan.VolumeGroupArgs{
 * 			ElasticSanName: pulumi.String("ti7q-k952-1qB3J_5"),
 * 			Encryption:     pulumi.String(elasticsan.EncryptionTypeEncryptionAtRestWithPlatformKey),
 * 			NetworkAcls: &elasticsan.NetworkRuleSetArgs{
 * 				VirtualNetworkRules: elasticsan.VirtualNetworkRuleArray{
 * 					&elasticsan.VirtualNetworkRuleArgs{
 * 						Action:                   elasticsan.ActionAllow,
 * 						VirtualNetworkResourceId: pulumi.String("aaaaaaaaaaaaaaaa"),
 * 					},
 * 				},
 * 			},
 * 			ProtocolType:      pulumi.String(elasticsan.StorageTargetTypeIscsi),
 * 			ResourceGroupName: pulumi.String("rgelasticsan"),
 * 			Tags: pulumi.StringMap{
 * 				"key5933": pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 * 			},
 * 			VolumeGroupName: pulumi.String("u_5I_1j4t3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.VolumeGroup;
 * import com.pulumi.azurenative.elasticsan.VolumeGroupArgs;
 * import com.pulumi.azurenative.elasticsan.inputs.NetworkRuleSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volumeGroup = new VolumeGroup("volumeGroup", VolumeGroupArgs.builder()
 *             .elasticSanName("ti7q-k952-1qB3J_5")
 *             .encryption("EncryptionAtRestWithPlatformKey")
 *             .networkAcls(NetworkRuleSetArgs.builder()
 *                 .virtualNetworkRules(VirtualNetworkRuleArgs.builder()
 *                     .action("Allow")
 *                     .virtualNetworkResourceId("aaaaaaaaaaaaaaaa")
 *                     .build())
 *                 .build())
 *             .protocolType("Iscsi")
 *             .resourceGroupName("rgelasticsan")
 *             .tags(Map.of("key5933", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"))
 *             .volumeGroupName("u_5I_1j4t3")
 *             .build());
 *     }
 * }
 * ```
 * ### VolumeGroups_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volumeGroup = new AzureNative.ElasticSan.VolumeGroup("volumeGroup", new()
 *     {
 *         ElasticSanName = "ti7q-k952-1qB3J_5",
 *         ResourceGroupName = "rgelasticsan",
 *         VolumeGroupName = "u_5I_1j4t3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewVolumeGroup(ctx, "volumeGroup", &elasticsan.VolumeGroupArgs{
 * 			ElasticSanName:    pulumi.String("ti7q-k952-1qB3J_5"),
 * 			ResourceGroupName: pulumi.String("rgelasticsan"),
 * 			VolumeGroupName:   pulumi.String("u_5I_1j4t3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.VolumeGroup;
 * import com.pulumi.azurenative.elasticsan.VolumeGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volumeGroup = new VolumeGroup("volumeGroup", VolumeGroupArgs.builder()
 *             .elasticSanName("ti7q-k952-1qB3J_5")
 *             .resourceGroupName("rgelasticsan")
 *             .volumeGroupName("u_5I_1j4t3")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:elasticsan:VolumeGroup aaaaaaaaaaaaaaaaaaaaaa /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}
 * ```
 */
public class VolumeGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.elasticsan.VolumeGroup,
) : KotlinCustomResource(javaResource, VolumeGroupMapper) {
    /**
     * Type of encryption
     */
    public val encryption: Output<String>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A collection of rules governing the accessibility from specific network locations.
     */
    public val networkAcls: Output<NetworkRuleSetResponse>?
        get() = javaResource.networkAcls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    networkRuleSetResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Type of storage target
     */
    public val protocolType: Output<String>?
        get() = javaResource.protocolType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * State of the operation on the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource metadata required by ARM RPC
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Azure resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VolumeGroupMapper : ResourceMapper<VolumeGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.elasticsan.VolumeGroup::class == javaResource::class

    override fun map(javaResource: Resource): VolumeGroup = VolumeGroup(
        javaResource as
            com.pulumi.azurenative.elasticsan.VolumeGroup,
    )
}

/**
 * @see [VolumeGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VolumeGroup].
 */
public suspend fun volumeGroup(name: String, block: suspend VolumeGroupResourceBuilder.() -> Unit):
    VolumeGroup {
    val builder = VolumeGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VolumeGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun volumeGroup(name: String): VolumeGroup {
    val builder = VolumeGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
