@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.inputs

import com.pulumi.azurenative.elasticsan.inputs.GetVolumeSnapshotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property elasticSanName The name of the ElasticSan.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property snapshotName The name of the volume snapshot within the given volume group.
 * @property volumeGroupName The name of the VolumeGroup.
 */
public data class GetVolumeSnapshotPlainArgs(
    public val elasticSanName: String,
    public val resourceGroupName: String,
    public val snapshotName: String,
    public val volumeGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.inputs.GetVolumeSnapshotPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.elasticsan.inputs.GetVolumeSnapshotPlainArgs =
        com.pulumi.azurenative.elasticsan.inputs.GetVolumeSnapshotPlainArgs.builder()
            .elasticSanName(elasticSanName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .snapshotName(snapshotName.let({ args0 -> args0 }))
            .volumeGroupName(volumeGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVolumeSnapshotPlainArgs].
 */
@PulumiTagMarker
public class GetVolumeSnapshotPlainArgsBuilder internal constructor() {
    private var elasticSanName: String? = null

    private var resourceGroupName: String? = null

    private var snapshotName: String? = null

    private var volumeGroupName: String? = null

    /**
     * @param value The name of the ElasticSan.
     */
    @JvmName("wdbwruueeysiubpa")
    public suspend fun elasticSanName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.elasticSanName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("japscajhubyuyrtd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the volume snapshot within the given volume group.
     */
    @JvmName("ajnugjteqxmiorhu")
    public suspend fun snapshotName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.snapshotName = mapped
    }

    /**
     * @param value The name of the VolumeGroup.
     */
    @JvmName("uvmedqvijwqubtix")
    public suspend fun volumeGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeGroupName = mapped
    }

    internal fun build(): GetVolumeSnapshotPlainArgs = GetVolumeSnapshotPlainArgs(
        elasticSanName = elasticSanName ?: throw PulumiNullFieldException("elasticSanName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        snapshotName = snapshotName ?: throw PulumiNullFieldException("snapshotName"),
        volumeGroupName = volumeGroupName ?: throw PulumiNullFieldException("volumeGroupName"),
    )
}
