@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.inputs

import com.pulumi.azurenative.elasticsan.inputs.SkuArgs.builder
import com.pulumi.azurenative.elasticsan.kotlin.enums.SkuName
import com.pulumi.azurenative.elasticsan.kotlin.enums.SkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The SKU name. Required for account creation; optional for update.
 * @property name The sku name.
 * @property tier The sku tier.
 */
public data class SkuArgs(
    public val name: Output<Either<String, SkuName>>,
    public val tier: Output<Either<String, SkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.elasticsan.inputs.SkuArgs =
        com.pulumi.azurenative.elasticsan.inputs.SkuArgs.builder()
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, SkuName>>? = null

    private var tier: Output<Either<String, SkuTier>>? = null

    /**
     * @param value The sku name.
     */
    @JvmName("eksjijjlkmufxqma")
    public suspend fun name(`value`: Output<Either<String, SkuName>>) {
        this.name = value
    }

    /**
     * @param value The sku tier.
     */
    @JvmName("ohwcrcurrbkdggtk")
    public suspend fun tier(`value`: Output<Either<String, SkuTier>>) {
        this.tier = value
    }

    /**
     * @param value The sku name.
     */
    @JvmName("xcjrvvxnkuaaejbf")
    public suspend fun name(`value`: Either<String, SkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("wlnlfxovsrkartrs")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("apokcroqktquvaff")
    public fun name(`value`: SkuName) {
        val toBeMapped = Either.ofRight<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sku tier.
     */
    @JvmName("fdeodtgjfjqncmko")
    public suspend fun tier(`value`: Either<String, SkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The sku tier.
     */
    @JvmName("xnbvuwnrsvhbsljy")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The sku tier.
     */
    @JvmName("lxxlntrmslpmgjfd")
    public fun tier(`value`: SkuTier) {
        val toBeMapped = Either.ofRight<String, SkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tier = tier,
    )
}
