@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.inputs

import com.pulumi.azurenative.elasticsan.inputs.VirtualNetworkRuleArgs.builder
import com.pulumi.azurenative.elasticsan.kotlin.enums.Action
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Virtual Network rule.
 * @property action The action of virtual network rule.
 * @property virtualNetworkResourceId Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
 */
public data class VirtualNetworkRuleArgs(
    public val action: Output<Action>? = null,
    public val virtualNetworkResourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.inputs.VirtualNetworkRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.elasticsan.inputs.VirtualNetworkRuleArgs =
        com.pulumi.azurenative.elasticsan.inputs.VirtualNetworkRuleArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .virtualNetworkResourceId(virtualNetworkResourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkRuleArgs].
 */
@PulumiTagMarker
public class VirtualNetworkRuleArgsBuilder internal constructor() {
    private var action: Output<Action>? = null

    private var virtualNetworkResourceId: Output<String>? = null

    /**
     * @param value The action of virtual network rule.
     */
    @JvmName("lblruktmngvidqgg")
    public suspend fun action(`value`: Output<Action>) {
        this.action = value
    }

    /**
     * @param value Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     */
    @JvmName("ovyajyspqitphfhi")
    public suspend fun virtualNetworkResourceId(`value`: Output<String>) {
        this.virtualNetworkResourceId = value
    }

    /**
     * @param value The action of virtual network rule.
     */
    @JvmName("pbecrtyxdrhhbtpr")
    public suspend fun action(`value`: Action?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     */
    @JvmName("ktalylmaistxrods")
    public suspend fun virtualNetworkResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkResourceId = mapped
    }

    internal fun build(): VirtualNetworkRuleArgs = VirtualNetworkRuleArgs(
        action = action,
        virtualNetworkResourceId = virtualNetworkResourceId ?: throw
            PulumiNullFieldException("virtualNetworkResourceId"),
    )
}
