@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Data source used when creating the volume.
 * @property createSource This enumerates the possible sources of a volume creation.
 * @property sourceUri If createOption is Copy, this is the ARM id of the source snapshot or disk. If createOption is Restore, this is the ARM-like id of the source disk restore point.
 */
public data class SourceCreationDataResponse(
    public val createSource: String? = null,
    public val sourceUri: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.elasticsan.outputs.SourceCreationDataResponse):
            SourceCreationDataResponse = SourceCreationDataResponse(
            createSource = javaType.createSource().map({ args0 -> args0 }).orElse(null),
            sourceUri = javaType.sourceUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
