@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.engagementfabric.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Channel].
 */
@PulumiTagMarker
public class ChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ChannelArgs = ChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ChannelArgsBuilder.() -> Unit) {
        val builder = ChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Channel {
        val builtJavaResource = com.pulumi.azurenative.engagementfabric.Channel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Channel(builtJavaResource)
    }
}

/**
 * The EngagementFabric channel
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### ChannelsCreateOrUpdateExample
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var channel = new AzureNative.EngagementFabric.Channel("channel", new()
 *     {
 *         AccountName = "ExampleAccount",
 *         ChannelFunctions = new[]
 *         {
 *             "MockFunction1",
 *             "MockFunction2",
 *         },
 *         ChannelName = "ExampleChannel",
 *         ChannelType = "MockChannel",
 *         Credentials =
 *         {
 *             { "AppId", "exampleApp" },
 *             { "AppKey", "exampleAppKey" },
 *         },
 *         ResourceGroupName = "ExampleRg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/engagementfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := engagementfabric.NewChannel(ctx, "channel", &engagementfabric.ChannelArgs{
 * 			AccountName: pulumi.String("ExampleAccount"),
 * 			ChannelFunctions: pulumi.StringArray{
 * 				pulumi.String("MockFunction1"),
 * 				pulumi.String("MockFunction2"),
 * 			},
 * 			ChannelName: pulumi.String("ExampleChannel"),
 * 			ChannelType: pulumi.String("MockChannel"),
 * 			Credentials: pulumi.StringMap{
 * 				"AppId":  pulumi.String("exampleApp"),
 * 				"AppKey": pulumi.String("exampleAppKey"),
 * 			},
 * 			ResourceGroupName: pulumi.String("ExampleRg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.engagementfabric.Channel;
 * import com.pulumi.azurenative.engagementfabric.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var channel = new Channel("channel", ChannelArgs.builder()
 *             .accountName("ExampleAccount")
 *             .channelFunctions(
 *                 "MockFunction1",
 *                 "MockFunction2")
 *             .channelName("ExampleChannel")
 *             .channelType("MockChannel")
 *             .credentials(Map.ofEntries(
 *                 Map.entry("AppId", "exampleApp"),
 *                 Map.entry("AppKey", "exampleAppKey")
 *             ))
 *             .resourceGroupName("ExampleRg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:engagementfabric:Channel ExampleChannel /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EngagementFabric/Accounts/{accountName}/Channels/{channelName}
 * ```
 */
public class Channel internal constructor(
    override val javaResource: com.pulumi.azurenative.engagementfabric.Channel,
) : KotlinCustomResource(javaResource, ChannelMapper) {
    /**
     * The functions to be enabled for the channel
     */
    public val channelFunctions: Output<List<String>>?
        get() = javaResource.channelFunctions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The channel type
     */
    public val channelType: Output<String>
        get() = javaResource.channelType().applyValue({ args0 -> args0 })

    /**
     * The channel credentials
     */
    public val credentials: Output<Map<String, String>>?
        get() = javaResource.credentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The fully qualified type of the resource
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ChannelMapper : ResourceMapper<Channel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.engagementfabric.Channel::class == javaResource::class

    override fun map(javaResource: Resource): Channel = Channel(
        javaResource as
            com.pulumi.azurenative.engagementfabric.Channel,
    )
}

/**
 * @see [Channel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Channel].
 */
public suspend fun channel(name: String, block: suspend ChannelResourceBuilder.() -> Unit):
    Channel {
    val builder = ChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Channel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun channel(name: String): Channel {
    val builder = ChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
