@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.engagementfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The EngagementFabric account
 * @property id The ID of the resource
 * @property location The location of the resource
 * @property name The name of the resource
 * @property sku The SKU of the resource
 * @property tags The tags of the resource
 * @property type The fully qualified type of the resource
 */
public data class GetAccountResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val sku: SKUResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.engagementfabric.outputs.GetAccountResult):
            GetAccountResult = GetAccountResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.engagementfabric.kotlin.outputs.SKUResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
