@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.enterpriseknowledgegraph.kotlin

import com.pulumi.azurenative.enterpriseknowledgegraph.EnterpriseKnowledgeGraphArgs.builder
import com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.inputs.EnterpriseKnowledgeGraphPropertiesArgs
import com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.inputs.EnterpriseKnowledgeGraphPropertiesArgsBuilder
import com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * EnterpriseKnowledgeGraph resource definition
 * Azure REST API version: 2018-12-03. Prior API version in Azure Native 1.x: 2018-12-03.
 * ## Example Usage
 * ### Create EnterpriseKnowledgeGraph
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var enterpriseKnowledgeGraph = new AzureNative.EnterpriseKnowledgeGraph.EnterpriseKnowledgeGraph("enterpriseKnowledgeGraph", new()
 *     {
 *         Location = "West US",
 *         Properties = null,
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "sampleekgname",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/enterpriseknowledgegraph/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := enterpriseknowledgegraph.NewEnterpriseKnowledgeGraph(ctx, "enterpriseKnowledgeGraph", &enterpriseknowledgegraph.EnterpriseKnowledgeGraphArgs{
 * 			Location:          pulumi.String("West US"),
 * 			Properties:        nil,
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("sampleekgname"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.enterpriseknowledgegraph.EnterpriseKnowledgeGraph;
 * import com.pulumi.azurenative.enterpriseknowledgegraph.EnterpriseKnowledgeGraphArgs;
 * import com.pulumi.azurenative.enterpriseknowledgegraph.inputs.EnterpriseKnowledgeGraphPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var enterpriseKnowledgeGraph = new EnterpriseKnowledgeGraph("enterpriseKnowledgeGraph", EnterpriseKnowledgeGraphArgs.builder()
 *             .location("West US")
 *             .properties()
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("sampleekgname")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:enterpriseknowledgegraph:EnterpriseKnowledgeGraph samplename /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EnterpriseKnowledgeGraph/services/{resourceName}
 * ```
 * @property location Specifies the location of the resource.
 * @property properties The set of properties specific to EnterpriseKnowledgeGraph resource
 * @property resourceGroupName The name of the EnterpriseKnowledgeGraph resource group in the user subscription.
 * @property resourceName The name of the EnterpriseKnowledgeGraph resource.
 * @property sku Gets or sets the SKU of the resource.
 * @property tags Contains resource tags defined as key/value pairs.
 */
public data class EnterpriseKnowledgeGraphArgs(
    public val location: Output<String>? = null,
    public val properties: Output<EnterpriseKnowledgeGraphPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.enterpriseknowledgegraph.EnterpriseKnowledgeGraphArgs> {
    override fun toJava():
        com.pulumi.azurenative.enterpriseknowledgegraph.EnterpriseKnowledgeGraphArgs =
        com.pulumi.azurenative.enterpriseknowledgegraph.EnterpriseKnowledgeGraphArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EnterpriseKnowledgeGraphArgs].
 */
@PulumiTagMarker
public class EnterpriseKnowledgeGraphArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<EnterpriseKnowledgeGraphPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("sgwutuodiyrmdteh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The set of properties specific to EnterpriseKnowledgeGraph resource
     */
    @JvmName("uqihtcjkvyldwmrn")
    public suspend fun properties(`value`: Output<EnterpriseKnowledgeGraphPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the EnterpriseKnowledgeGraph resource group in the user subscription.
     */
    @JvmName("ipvxsudxpqhdrbin")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the EnterpriseKnowledgeGraph resource.
     */
    @JvmName("oyfgmsynboqemsok")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Gets or sets the SKU of the resource.
     */
    @JvmName("khycmtxujirxkbyw")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Contains resource tags defined as key/value pairs.
     */
    @JvmName("txbodjkqnteghwaj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("txqiclhlsgcaavdk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The set of properties specific to EnterpriseKnowledgeGraph resource
     */
    @JvmName("xybpcrschrbrpngl")
    public suspend fun properties(`value`: EnterpriseKnowledgeGraphPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The set of properties specific to EnterpriseKnowledgeGraph resource
     */
    @JvmName("ragwbffgpomjamox")
    public suspend
    fun properties(argument: suspend EnterpriseKnowledgeGraphPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EnterpriseKnowledgeGraphPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the EnterpriseKnowledgeGraph resource group in the user subscription.
     */
    @JvmName("dslusfxwlqjabstt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the EnterpriseKnowledgeGraph resource.
     */
    @JvmName("mosmncqdboeogboi")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Gets or sets the SKU of the resource.
     */
    @JvmName("dtljqpxghcggsmty")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Gets or sets the SKU of the resource.
     */
    @JvmName("tfbsencpuvswhjdc")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Contains resource tags defined as key/value pairs.
     */
    @JvmName("cgoblmumtwtuhgnk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Contains resource tags defined as key/value pairs.
     */
    @JvmName("jjviqprhfjcfanxf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EnterpriseKnowledgeGraphArgs = EnterpriseKnowledgeGraphArgs(
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        sku = sku,
        tags = tags,
    )
}
