@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CaCertificate].
 */
@PulumiTagMarker
public class CaCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CaCertificateArgs = CaCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CaCertificateArgsBuilder.() -> Unit) {
        val builder = CaCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CaCertificate {
        val builtJavaResource = com.pulumi.azurenative.eventgrid.CaCertificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CaCertificate(builtJavaResource)
    }
}

/**
 * The CA Certificate resource.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview.
 * ## Example Usage
 * ### CaCertificates_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var caCertificate = new AzureNative.EventGrid.CaCertificate("caCertificate", new()
 *     {
 *         CaCertificateName = "exampleCACertificateName1",
 *         Description = "This is a test certificate",
 *         EncodedCertificate = "base64EncodePemFormattedCertificateString",
 *         NamespaceName = "exampleNamespaceName1",
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewCaCertificate(ctx, "caCertificate", &eventgrid.CaCertificateArgs{
 * 			CaCertificateName:  pulumi.String("exampleCACertificateName1"),
 * 			Description:        pulumi.String("This is a test certificate"),
 * 			EncodedCertificate: pulumi.String("base64EncodePemFormattedCertificateString"),
 * 			NamespaceName:      pulumi.String("exampleNamespaceName1"),
 * 			ResourceGroupName:  pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.CaCertificate;
 * import com.pulumi.azurenative.eventgrid.CaCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var caCertificate = new CaCertificate("caCertificate", CaCertificateArgs.builder()
 *             .caCertificateName("exampleCACertificateName1")
 *             .description("This is a test certificate")
 *             .encodedCertificate("base64EncodePemFormattedCertificateString")
 *             .namespaceName("exampleNamespaceName1")
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:CaCertificate exampleCACertificateName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/caCertificates/{caCertificateName}
 * ```
 */
public class CaCertificate internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.CaCertificate,
) : KotlinCustomResource(javaResource, CaCertificateMapper) {
    /**
     * Description for the CA Certificate resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Base64 encoded PEM (Privacy Enhanced Mail) format certificate data.
     */
    public val encodedCertificate: Output<String>?
        get() = javaResource.encodedCertificate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Certificate expiry time in UTC. This is a read-only field.
     */
    public val expiryTimeInUtc: Output<String>
        get() = javaResource.expiryTimeInUtc().applyValue({ args0 -> args0 })

    /**
     * Certificate issue time in UTC. This is a read-only field.
     */
    public val issueTimeInUtc: Output<String>
        get() = javaResource.issueTimeInUtc().applyValue({ args0 -> args0 })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the CA Certificate resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The system metadata relating to the CaCertificate resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CaCertificateMapper : ResourceMapper<CaCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.CaCertificate::class == javaResource::class

    override fun map(javaResource: Resource): CaCertificate = CaCertificate(
        javaResource as
            com.pulumi.azurenative.eventgrid.CaCertificate,
    )
}

/**
 * @see [CaCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CaCertificate].
 */
public suspend fun caCertificate(
    name: String,
    block: suspend CaCertificateResourceBuilder.() -> Unit,
): CaCertificate {
    val builder = CaCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CaCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun caCertificate(name: String): CaCertificate {
    val builder = CaCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
