@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.ChannelArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.ChannelProvisioningState
import com.pulumi.azurenative.eventgrid.kotlin.enums.ChannelType
import com.pulumi.azurenative.eventgrid.kotlin.enums.ReadinessState
import com.pulumi.azurenative.eventgrid.kotlin.inputs.PartnerTopicInfoArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.PartnerTopicInfoArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Channel info.
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2021-10-15-preview.
 * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
 * ## Example Usage
 * ### Channels_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var channel = new AzureNative.EventGrid.Channel("channel", new()
 *     {
 *         ChannelName = "exampleChannelName1",
 *         ChannelType = AzureNative.EventGrid.ChannelType.PartnerTopic,
 *         ExpirationTimeIfNotActivatedUtc = "2021-10-21T22:50:25.410433Z",
 *         MessageForActivation = "Example message to approver",
 *         PartnerNamespaceName = "examplePartnerNamespaceName1",
 *         PartnerTopicInfo = new AzureNative.EventGrid.Inputs.PartnerTopicInfoArgs
 *         {
 *             AzureSubscriptionId = "5b4b650e-28b9-4790-b3ab-ddbd88d727c4",
 *             Name = "examplePartnerTopic1",
 *             ResourceGroupName = "examplerg2",
 *             Source = "ContosoCorp.Accounts.User1",
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewChannel(ctx, "channel", &eventgrid.ChannelArgs{
 * 			ChannelName:                     pulumi.String("exampleChannelName1"),
 * 			ChannelType:                     pulumi.String(eventgrid.ChannelTypePartnerTopic),
 * 			ExpirationTimeIfNotActivatedUtc: pulumi.String("2021-10-21T22:50:25.410433Z"),
 * 			MessageForActivation:            pulumi.String("Example message to approver"),
 * 			PartnerNamespaceName:            pulumi.String("examplePartnerNamespaceName1"),
 * 			PartnerTopicInfo: &eventgrid.PartnerTopicInfoArgs{
 * 				AzureSubscriptionId: pulumi.String("5b4b650e-28b9-4790-b3ab-ddbd88d727c4"),
 * 				Name:                pulumi.String("examplePartnerTopic1"),
 * 				ResourceGroupName:   pulumi.String("examplerg2"),
 * 				Source:              pulumi.String("ContosoCorp.Accounts.User1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.Channel;
 * import com.pulumi.azurenative.eventgrid.ChannelArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.PartnerTopicInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var channel = new Channel("channel", ChannelArgs.builder()
 *             .channelName("exampleChannelName1")
 *             .channelType("PartnerTopic")
 *             .expirationTimeIfNotActivatedUtc("2021-10-21T22:50:25.410433Z")
 *             .messageForActivation("Example message to approver")
 *             .partnerNamespaceName("examplePartnerNamespaceName1")
 *             .partnerTopicInfo(PartnerTopicInfoArgs.builder()
 *                 .azureSubscriptionId("5b4b650e-28b9-4790-b3ab-ddbd88d727c4")
 *                 .name("examplePartnerTopic1")
 *                 .resourceGroupName("examplerg2")
 *                 .source("ContosoCorp.Accounts.User1")
 *                 .build())
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:Channel exampleChannelName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}
 * ```
 * @property channelName Name of the channel.
 * @property channelType The type of the event channel which represents the direction flow of events.
 * @property expirationTimeIfNotActivatedUtc Expiration time of the channel. If this timer expires while the corresponding partner topic is never activated,
 * the channel and corresponding partner topic are deleted.
 * @property messageForActivation Context or helpful message that can be used during the approval process by the subscriber.
 * @property partnerNamespaceName Name of the partner namespace.
 * @property partnerTopicInfo This property should be populated when channelType is PartnerTopic and represents information about the partner topic resource corresponding to the channel.
 * @property provisioningState Provisioning state of the channel.
 * @property readinessState The readiness state of the corresponding partner topic.
 * @property resourceGroupName The name of the resource group within the partners subscription.
 */
public data class ChannelArgs(
    public val channelName: Output<String>? = null,
    public val channelType: Output<Either<String, ChannelType>>? = null,
    public val expirationTimeIfNotActivatedUtc: Output<String>? = null,
    public val messageForActivation: Output<String>? = null,
    public val partnerNamespaceName: Output<String>? = null,
    public val partnerTopicInfo: Output<PartnerTopicInfoArgs>? = null,
    public val provisioningState: Output<Either<String, ChannelProvisioningState>>? = null,
    public val readinessState: Output<Either<String, ReadinessState>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.ChannelArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.ChannelArgs =
        com.pulumi.azurenative.eventgrid.ChannelArgs.builder()
            .channelName(channelName?.applyValue({ args0 -> args0 }))
            .channelType(
                channelType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .expirationTimeIfNotActivatedUtc(expirationTimeIfNotActivatedUtc?.applyValue({ args0 -> args0 }))
            .messageForActivation(messageForActivation?.applyValue({ args0 -> args0 }))
            .partnerNamespaceName(partnerNamespaceName?.applyValue({ args0 -> args0 }))
            .partnerTopicInfo(partnerTopicInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .readinessState(
                readinessState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelArgs].
 */
@PulumiTagMarker
public class ChannelArgsBuilder internal constructor() {
    private var channelName: Output<String>? = null

    private var channelType: Output<Either<String, ChannelType>>? = null

    private var expirationTimeIfNotActivatedUtc: Output<String>? = null

    private var messageForActivation: Output<String>? = null

    private var partnerNamespaceName: Output<String>? = null

    private var partnerTopicInfo: Output<PartnerTopicInfoArgs>? = null

    private var provisioningState: Output<Either<String, ChannelProvisioningState>>? = null

    private var readinessState: Output<Either<String, ReadinessState>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the channel.
     */
    @JvmName("bfvjvuxqluxgpxyv")
    public suspend fun channelName(`value`: Output<String>) {
        this.channelName = value
    }

    /**
     * @param value The type of the event channel which represents the direction flow of events.
     */
    @JvmName("voqblqsaemkqqqqi")
    public suspend fun channelType(`value`: Output<Either<String, ChannelType>>) {
        this.channelType = value
    }

    /**
     * @param value Expiration time of the channel. If this timer expires while the corresponding partner topic is never activated,
     * the channel and corresponding partner topic are deleted.
     */
    @JvmName("jennhugwcobaxuii")
    public suspend fun expirationTimeIfNotActivatedUtc(`value`: Output<String>) {
        this.expirationTimeIfNotActivatedUtc = value
    }

    /**
     * @param value Context or helpful message that can be used during the approval process by the subscriber.
     */
    @JvmName("jyspvduoeowpofya")
    public suspend fun messageForActivation(`value`: Output<String>) {
        this.messageForActivation = value
    }

    /**
     * @param value Name of the partner namespace.
     */
    @JvmName("xjyqkttmbqvbxbcx")
    public suspend fun partnerNamespaceName(`value`: Output<String>) {
        this.partnerNamespaceName = value
    }

    /**
     * @param value This property should be populated when channelType is PartnerTopic and represents information about the partner topic resource corresponding to the channel.
     */
    @JvmName("pcsnwuegmpjecguo")
    public suspend fun partnerTopicInfo(`value`: Output<PartnerTopicInfoArgs>) {
        this.partnerTopicInfo = value
    }

    /**
     * @param value Provisioning state of the channel.
     */
    @JvmName("rwyxxamijdybtfac")
    public suspend fun provisioningState(`value`: Output<Either<String, ChannelProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The readiness state of the corresponding partner topic.
     */
    @JvmName("lujfvweuthgolxie")
    public suspend fun readinessState(`value`: Output<Either<String, ReadinessState>>) {
        this.readinessState = value
    }

    /**
     * @param value The name of the resource group within the partners subscription.
     */
    @JvmName("bvqehbjkxybsrmdv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the channel.
     */
    @JvmName("faogwtfmriweqglp")
    public suspend fun channelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelName = mapped
    }

    /**
     * @param value The type of the event channel which represents the direction flow of events.
     */
    @JvmName("iigxgglfupyysjyf")
    public suspend fun channelType(`value`: Either<String, ChannelType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelType = mapped
    }

    /**
     * @param value The type of the event channel which represents the direction flow of events.
     */
    @JvmName("fgpbbvjsllaeeify")
    public fun channelType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ChannelType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelType = mapped
    }

    /**
     * @param value The type of the event channel which represents the direction flow of events.
     */
    @JvmName("lrduregpirnlhijf")
    public fun channelType(`value`: ChannelType) {
        val toBeMapped = Either.ofRight<String, ChannelType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelType = mapped
    }

    /**
     * @param value Expiration time of the channel. If this timer expires while the corresponding partner topic is never activated,
     * the channel and corresponding partner topic are deleted.
     */
    @JvmName("dhsxkqjrmhelcjvq")
    public suspend fun expirationTimeIfNotActivatedUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationTimeIfNotActivatedUtc = mapped
    }

    /**
     * @param value Context or helpful message that can be used during the approval process by the subscriber.
     */
    @JvmName("vdmjpjfjitjqlfow")
    public suspend fun messageForActivation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageForActivation = mapped
    }

    /**
     * @param value Name of the partner namespace.
     */
    @JvmName("nxvtmkehhlobyvrk")
    public suspend fun partnerNamespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerNamespaceName = mapped
    }

    /**
     * @param value This property should be populated when channelType is PartnerTopic and represents information about the partner topic resource corresponding to the channel.
     */
    @JvmName("chnkinnqyedifddi")
    public suspend fun partnerTopicInfo(`value`: PartnerTopicInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerTopicInfo = mapped
    }

    /**
     * @param argument This property should be populated when channelType is PartnerTopic and represents information about the partner topic resource corresponding to the channel.
     */
    @JvmName("ixkbjdabqjwoiolu")
    public suspend fun partnerTopicInfo(argument: suspend PartnerTopicInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PartnerTopicInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.partnerTopicInfo = mapped
    }

    /**
     * @param value Provisioning state of the channel.
     */
    @JvmName("lrswvimaorfpndli")
    public suspend fun provisioningState(`value`: Either<String, ChannelProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the channel.
     */
    @JvmName("lodfiddjxuhgtbqp")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ChannelProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the channel.
     */
    @JvmName("pqaumxekxasgfjyp")
    public fun provisioningState(`value`: ChannelProvisioningState) {
        val toBeMapped = Either.ofRight<String, ChannelProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The readiness state of the corresponding partner topic.
     */
    @JvmName("ahqhisjlorccgiuh")
    public suspend fun readinessState(`value`: Either<String, ReadinessState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessState = mapped
    }

    /**
     * @param value The readiness state of the corresponding partner topic.
     */
    @JvmName("cyhivdgsqdffgbvq")
    public fun readinessState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReadinessState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.readinessState = mapped
    }

    /**
     * @param value The readiness state of the corresponding partner topic.
     */
    @JvmName("chwyvcjliurumryj")
    public fun readinessState(`value`: ReadinessState) {
        val toBeMapped = Either.ofRight<String, ReadinessState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.readinessState = mapped
    }

    /**
     * @param value The name of the resource group within the partners subscription.
     */
    @JvmName("vnumevuffarpunfu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ChannelArgs = ChannelArgs(
        channelName = channelName,
        channelType = channelType,
        expirationTimeIfNotActivatedUtc = expirationTimeIfNotActivatedUtc,
        messageForActivation = messageForActivation,
        partnerNamespaceName = partnerNamespaceName,
        partnerTopicInfo = partnerTopicInfo,
        provisioningState = provisioningState,
        readinessState = readinessState,
        resourceGroupName = resourceGroupName,
    )
}
