@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.ClientAuthenticationResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.ClientCertificateAuthenticationResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.eventgrid.kotlin.outputs.ClientAuthenticationResponse.Companion.toKotlin as clientAuthenticationResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.ClientCertificateAuthenticationResponse.Companion.toKotlin as clientCertificateAuthenticationResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Client].
 */
@PulumiTagMarker
public class ClientResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClientArgs = ClientArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClientArgsBuilder.() -> Unit) {
        val builder = ClientArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Client {
        val builtJavaResource = com.pulumi.azurenative.eventgrid.Client(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Client(builtJavaResource)
    }
}

/**
 * The Client resource.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview.
 * ## Example Usage
 * ### Clients_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var client = new AzureNative.EventGrid.Client("client", new()
 *     {
 *         Attributes = new Dictionary<string, object?>
 *         {
 *             ["deviceTypes"] = new[]
 *             {
 *                 "Fan",
 *                 "Light",
 *                 "AC",
 *             },
 *             ["floor"] = 3,
 *             ["room"] = "345",
 *         },
 *         ClientCertificateAuthentication = new AzureNative.EventGrid.Inputs.ClientCertificateAuthenticationArgs
 *         {
 *             ValidationScheme = AzureNative.EventGrid.ClientCertificateValidationScheme.SubjectMatchesAuthenticationName,
 *         },
 *         ClientName = "exampleClientName1",
 *         Description = "This is a test client",
 *         NamespaceName = "exampleNamespaceName1",
 *         ResourceGroupName = "examplerg",
 *         State = AzureNative.EventGrid.ClientState.Enabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewClient(ctx, "client", &eventgrid.ClientArgs{
 * 			Attributes: pulumi.Any(map[string]interface{}{
 * 				"deviceTypes": []string{
 * 					"Fan",
 * 					"Light",
 * 					"AC",
 * 				},
 * 				"floor": 3,
 * 				"room":  "345",
 * 			}),
 * 			ClientCertificateAuthentication: &eventgrid.ClientCertificateAuthenticationArgs{
 * 				ValidationScheme: pulumi.String(eventgrid.ClientCertificateValidationSchemeSubjectMatchesAuthenticationName),
 * 			},
 * 			ClientName:        pulumi.String("exampleClientName1"),
 * 			Description:       pulumi.String("This is a test client"),
 * 			NamespaceName:     pulumi.String("exampleNamespaceName1"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			State:             pulumi.String(eventgrid.ClientStateEnabled),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.Client;
 * import com.pulumi.azurenative.eventgrid.ClientArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.ClientCertificateAuthenticationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var client = new Client("client", ClientArgs.builder()
 *             .attributes(Map.ofEntries(
 *                 Map.entry("deviceTypes",
 *                     "Fan",
 *                     "Light",
 *                     "AC"),
 *                 Map.entry("floor", 3),
 *                 Map.entry("room", "345")
 *             ))
 *             .clientCertificateAuthentication(ClientCertificateAuthenticationArgs.builder()
 *                 .validationScheme("SubjectMatchesAuthenticationName")
 *                 .build())
 *             .clientName("exampleClientName1")
 *             .description("This is a test client")
 *             .namespaceName("exampleNamespaceName1")
 *             .resourceGroupName("examplerg")
 *             .state("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:Client exampleClientName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/clients/{clientName}
 * ```
 */
public class Client internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.Client,
) : KotlinCustomResource(javaResource, ClientMapper) {
    /**
     * Attributes for the client. Supported values are int, bool, string, string[].
     * Example:
     * "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }
     */
    public val attributes: Output<Any>?
        get() = javaResource.attributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Authentication information for the client.
     */
    public val authentication: Output<ClientAuthenticationResponse>?
        get() = javaResource.authentication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clientAuthenticationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name presented by the client for authentication. The default value is the name of the resource.
     */
    public val authenticationName: Output<String>?
        get() = javaResource.authenticationName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The client certificate authentication information.
     */
    public val clientCertificateAuthentication: Output<ClientCertificateAuthenticationResponse>?
        get() = javaResource.clientCertificateAuthentication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clientCertificateAuthenticationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Description for the Client resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the Client resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Indicates if the client is enabled or not. Default value is Enabled.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The system metadata relating to the Client resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ClientMapper : ResourceMapper<Client> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.Client::class == javaResource::class

    override fun map(javaResource: Resource): Client = Client(
        javaResource as
            com.pulumi.azurenative.eventgrid.Client,
    )
}

/**
 * @see [Client].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Client].
 */
public suspend fun client(name: String, block: suspend ClientResourceBuilder.() -> Unit): Client {
    val builder = ClientResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Client].
 * @param name The _unique_ name of the resulting resource.
 */
public fun client(name: String): Client {
    val builder = ClientResourceBuilder()
    builder.name(name)
    return builder.build()
}
