@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ClientGroup].
 */
@PulumiTagMarker
public class ClientGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClientGroupArgs = ClientGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClientGroupArgsBuilder.() -> Unit) {
        val builder = ClientGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClientGroup {
        val builtJavaResource = com.pulumi.azurenative.eventgrid.ClientGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClientGroup(builtJavaResource)
    }
}

/**
 * The Client group resource.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview.
 * ## Example Usage
 * ### ClientGroups_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var clientGroup = new AzureNative.EventGrid.ClientGroup("clientGroup", new()
 *     {
 *         ClientGroupName = "exampleClientGroupName1",
 *         Description = "This is a test client group",
 *         NamespaceName = "exampleNamespaceName1",
 *         Query = "attributes.b IN ['a', 'b', 'c']",
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewClientGroup(ctx, "clientGroup", &eventgrid.ClientGroupArgs{
 * 			ClientGroupName:   pulumi.String("exampleClientGroupName1"),
 * 			Description:       pulumi.String("This is a test client group"),
 * 			NamespaceName:     pulumi.String("exampleNamespaceName1"),
 * 			Query:             pulumi.String("attributes.b IN ['a', 'b', 'c']"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.ClientGroup;
 * import com.pulumi.azurenative.eventgrid.ClientGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var clientGroup = new ClientGroup("clientGroup", ClientGroupArgs.builder()
 *             .clientGroupName("exampleClientGroupName1")
 *             .description("This is a test client group")
 *             .namespaceName("exampleNamespaceName1")
 *             .query("attributes.b IN ['a', 'b', 'c']")
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:ClientGroup exampleClientGroupName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/clientGroups/{clientGroupName}
 * ```
 */
public class ClientGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.ClientGroup,
) : KotlinCustomResource(javaResource, ClientGroupMapper) {
    /**
     * Description for the Client Group resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the ClientGroup resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The grouping query for the clients.
     * Example : attributes.keyName IN ['a', 'b', 'c'].
     */
    public val query: Output<String>?
        get() = javaResource.query().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The system metadata relating to the ClientGroup resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ClientGroupMapper : ResourceMapper<ClientGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.ClientGroup::class == javaResource::class

    override fun map(javaResource: Resource): ClientGroup = ClientGroup(
        javaResource as
            com.pulumi.azurenative.eventgrid.ClientGroup,
    )
}

/**
 * @see [ClientGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClientGroup].
 */
public suspend fun clientGroup(name: String, block: suspend ClientGroupResourceBuilder.() -> Unit):
    ClientGroup {
    val builder = ClientGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClientGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clientGroup(name: String): ClientGroup {
    val builder = ClientGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
