@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.DomainArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.DataResidencyBoundary
import com.pulumi.azurenative.eventgrid.kotlin.enums.InputSchema
import com.pulumi.azurenative.eventgrid.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.eventgrid.kotlin.inputs.IdentityInfoArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.IdentityInfoArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.InboundIpRuleArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.InboundIpRuleArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.JsonInputSchemaMappingArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.JsonInputSchemaMappingArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * EventGrid Domain.
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2020-04-01-preview, 2023-06-01-preview, 2023-12-15-preview.
 * ## Example Usage
 * ### Domains_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domain = new AzureNative.EventGrid.Domain("domain", new()
 *     {
 *         DomainName = "exampledomain1",
 *         InboundIpRules = new[]
 *         {
 *             new AzureNative.EventGrid.Inputs.InboundIpRuleArgs
 *             {
 *                 Action = AzureNative.EventGrid.IpActionType.Allow,
 *                 IpMask = "12.18.30.15",
 *             },
 *             new AzureNative.EventGrid.Inputs.InboundIpRuleArgs
 *             {
 *                 Action = AzureNative.EventGrid.IpActionType.Allow,
 *                 IpMask = "12.18.176.1",
 *             },
 *         },
 *         Location = "westus2",
 *         PublicNetworkAccess = AzureNative.EventGrid.PublicNetworkAccess.Enabled,
 *         ResourceGroupName = "examplerg",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewDomain(ctx, "domain", &eventgrid.DomainArgs{
 * 			DomainName: pulumi.String("exampledomain1"),
 * 			InboundIpRules: eventgrid.InboundIpRuleArray{
 * 				&eventgrid.InboundIpRuleArgs{
 * 					Action: pulumi.String(eventgrid.IpActionTypeAllow),
 * 					IpMask: pulumi.String("12.18.30.15"),
 * 				},
 * 				&eventgrid.InboundIpRuleArgs{
 * 					Action: pulumi.String(eventgrid.IpActionTypeAllow),
 * 					IpMask: pulumi.String("12.18.176.1"),
 * 				},
 * 			},
 * 			Location:            pulumi.String("westus2"),
 * 			PublicNetworkAccess: pulumi.String(eventgrid.PublicNetworkAccessEnabled),
 * 			ResourceGroupName:   pulumi.String("examplerg"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.Domain;
 * import com.pulumi.azurenative.eventgrid.DomainArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.InboundIpRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domain = new Domain("domain", DomainArgs.builder()
 *             .domainName("exampledomain1")
 *             .inboundIpRules(
 *                 InboundIpRuleArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("12.18.30.15")
 *                     .build(),
 *                 InboundIpRuleArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("12.18.176.1")
 *                     .build())
 *             .location("westus2")
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("examplerg")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:Domain exampledomain1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/domains/{domainName}
 * ```
 * @property autoCreateTopicWithFirstSubscription This Boolean is used to specify the creation mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain resource.
 * In this context, creation of domain topic can be auto-managed (when true) or self-managed (when false). The default value for this property is true.
 * When this property is null or set to true, Event Grid is responsible of automatically creating the domain topic when the first event subscription is
 * created at the scope of the domain topic. If this property is set to false, then creating the first event subscription will require creating a domain topic
 * by the user. The self-management mode can be used if the user wants full control of when the domain topic is created, while auto-managed mode provides the
 * flexibility to perform less operations and manage fewer resources by the user. Also, note that in auto-managed creation mode, user is allowed to create the
 * domain topic on demand if needed.
 * @property autoDeleteTopicWithLastSubscription This Boolean is used to specify the deletion mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain resource.
 * In this context, deletion of domain topic can be auto-managed (when true) or self-managed (when false). The default value for this property is true.
 * When this property is set to true, Event Grid is responsible of automatically deleting the domain topic when the last event subscription at the scope
 * of the domain topic is deleted. If this property is set to false, then the user needs to manually delete the domain topic when it is no longer needed
 * (e.g., when last event subscription is deleted and the resource needs to be cleaned up). The self-management mode can be used if the user wants full
 * control of when the domain topic needs to be deleted, while auto-managed mode provides the flexibility to perform less operations and manage fewer
 * resources by the user.
 * @property dataResidencyBoundary Data Residency Boundary of the resource.
 * @property disableLocalAuth This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the domain.
 * @property domainName Name of the domain.
 * @property identity Identity information for the Event Grid Domain resource.
 * @property inboundIpRules This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
 * @property inputSchema This determines the format that Event Grid should expect for incoming events published to the Event Grid Domain Resource.
 * @property inputSchemaMapping Information about the InputSchemaMapping which specified the info about mapping event payload.
 * @property location Location of the resource.
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled.
 * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules" />
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property tags Tags of the resource.
 */
public data class DomainArgs(
    public val autoCreateTopicWithFirstSubscription: Output<Boolean>? = null,
    public val autoDeleteTopicWithLastSubscription: Output<Boolean>? = null,
    public val dataResidencyBoundary: Output<Either<String, DataResidencyBoundary>>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val domainName: Output<String>? = null,
    public val identity: Output<IdentityInfoArgs>? = null,
    public val inboundIpRules: Output<List<InboundIpRuleArgs>>? = null,
    public val inputSchema: Output<Either<String, InputSchema>>? = null,
    public val inputSchemaMapping: Output<JsonInputSchemaMappingArgs>? = null,
    public val location: Output<String>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.DomainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.DomainArgs =
        com.pulumi.azurenative.eventgrid.DomainArgs.builder()
            .autoCreateTopicWithFirstSubscription(
                autoCreateTopicWithFirstSubscription?.applyValue({ args0 ->
                    args0
                }),
            )
            .autoDeleteTopicWithLastSubscription(
                autoDeleteTopicWithLastSubscription?.applyValue({ args0 ->
                    args0
                }),
            )
            .dataResidencyBoundary(
                dataResidencyBoundary?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inboundIpRules(
                inboundIpRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .inputSchema(
                inputSchema?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .inputSchemaMapping(
                inputSchemaMapping?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var autoCreateTopicWithFirstSubscription: Output<Boolean>? = null

    private var autoDeleteTopicWithLastSubscription: Output<Boolean>? = null

    private var dataResidencyBoundary: Output<Either<String, DataResidencyBoundary>>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var domainName: Output<String>? = null

    private var identity: Output<IdentityInfoArgs>? = null

    private var inboundIpRules: Output<List<InboundIpRuleArgs>>? = null

    private var inputSchema: Output<Either<String, InputSchema>>? = null

    private var inputSchemaMapping: Output<JsonInputSchemaMappingArgs>? = null

    private var location: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value This Boolean is used to specify the creation mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain resource.
     * In this context, creation of domain topic can be auto-managed (when true) or self-managed (when false). The default value for this property is true.
     * When this property is null or set to true, Event Grid is responsible of automatically creating the domain topic when the first event subscription is
     * created at the scope of the domain topic. If this property is set to false, then creating the first event subscription will require creating a domain topic
     * by the user. The self-management mode can be used if the user wants full control of when the domain topic is created, while auto-managed mode provides the
     * flexibility to perform less operations and manage fewer resources by the user. Also, note that in auto-managed creation mode, user is allowed to create the
     * domain topic on demand if needed.
     */
    @JvmName("wsxvwvssdmmydxuu")
    public suspend fun autoCreateTopicWithFirstSubscription(`value`: Output<Boolean>) {
        this.autoCreateTopicWithFirstSubscription = value
    }

    /**
     * @param value This Boolean is used to specify the deletion mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain resource.
     * In this context, deletion of domain topic can be auto-managed (when true) or self-managed (when false). The default value for this property is true.
     * When this property is set to true, Event Grid is responsible of automatically deleting the domain topic when the last event subscription at the scope
     * of the domain topic is deleted. If this property is set to false, then the user needs to manually delete the domain topic when it is no longer needed
     * (e.g., when last event subscription is deleted and the resource needs to be cleaned up). The self-management mode can be used if the user wants full
     * control of when the domain topic needs to be deleted, while auto-managed mode provides the flexibility to perform less operations and manage fewer
     * resources by the user.
     */
    @JvmName("dhnrswfgiraukuhh")
    public suspend fun autoDeleteTopicWithLastSubscription(`value`: Output<Boolean>) {
        this.autoDeleteTopicWithLastSubscription = value
    }

    /**
     * @param value Data Residency Boundary of the resource.
     */
    @JvmName("qnmsncquddfaelrg")
    public suspend fun dataResidencyBoundary(`value`: Output<Either<String, DataResidencyBoundary>>) {
        this.dataResidencyBoundary = value
    }

    /**
     * @param value This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the domain.
     */
    @JvmName("kvdjdhsitmomrroc")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value Name of the domain.
     */
    @JvmName("bujbmkdbxiquurat")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Identity information for the Event Grid Domain resource.
     */
    @JvmName("jdoecqmfafvdegxg")
    public suspend fun identity(`value`: Output<IdentityInfoArgs>) {
        this.identity = value
    }

    /**
     * @param value This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("rknhdskfqhykwqjs")
    public suspend fun inboundIpRules(`value`: Output<List<InboundIpRuleArgs>>) {
        this.inboundIpRules = value
    }

    @JvmName("vqahtkhdpmgbgqvr")
    public suspend fun inboundIpRules(vararg values: Output<InboundIpRuleArgs>) {
        this.inboundIpRules = Output.all(values.asList())
    }

    /**
     * @param values This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("ilhxexfohvqltsao")
    public suspend fun inboundIpRules(values: List<Output<InboundIpRuleArgs>>) {
        this.inboundIpRules = Output.all(values)
    }

    /**
     * @param value This determines the format that Event Grid should expect for incoming events published to the Event Grid Domain Resource.
     */
    @JvmName("lggvvsxnrintsyyp")
    public suspend fun inputSchema(`value`: Output<Either<String, InputSchema>>) {
        this.inputSchema = value
    }

    /**
     * @param value Information about the InputSchemaMapping which specified the info about mapping event payload.
     */
    @JvmName("yrlfrdmnlghaeejs")
    public suspend fun inputSchemaMapping(`value`: Output<JsonInputSchemaMappingArgs>) {
        this.inputSchemaMapping = value
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("xjdejrrwkwrelcyt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules" />
     */
    @JvmName("sejpccoiejdflsrx")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("ugwborgjgrrnviod")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("vjqfwfxmjcfwmlxw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value This Boolean is used to specify the creation mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain resource.
     * In this context, creation of domain topic can be auto-managed (when true) or self-managed (when false). The default value for this property is true.
     * When this property is null or set to true, Event Grid is responsible of automatically creating the domain topic when the first event subscription is
     * created at the scope of the domain topic. If this property is set to false, then creating the first event subscription will require creating a domain topic
     * by the user. The self-management mode can be used if the user wants full control of when the domain topic is created, while auto-managed mode provides the
     * flexibility to perform less operations and manage fewer resources by the user. Also, note that in auto-managed creation mode, user is allowed to create the
     * domain topic on demand if needed.
     */
    @JvmName("lrgwfjspdtpyxdrv")
    public suspend fun autoCreateTopicWithFirstSubscription(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoCreateTopicWithFirstSubscription = mapped
    }

    /**
     * @param value This Boolean is used to specify the deletion mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain resource.
     * In this context, deletion of domain topic can be auto-managed (when true) or self-managed (when false). The default value for this property is true.
     * When this property is set to true, Event Grid is responsible of automatically deleting the domain topic when the last event subscription at the scope
     * of the domain topic is deleted. If this property is set to false, then the user needs to manually delete the domain topic when it is no longer needed
     * (e.g., when last event subscription is deleted and the resource needs to be cleaned up). The self-management mode can be used if the user wants full
     * control of when the domain topic needs to be deleted, while auto-managed mode provides the flexibility to perform less operations and manage fewer
     * resources by the user.
     */
    @JvmName("hlovjcvwplbcbqyd")
    public suspend fun autoDeleteTopicWithLastSubscription(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDeleteTopicWithLastSubscription = mapped
    }

    /**
     * @param value Data Residency Boundary of the resource.
     */
    @JvmName("xfiudslspgqqmdlf")
    public suspend fun dataResidencyBoundary(`value`: Either<String, DataResidencyBoundary>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataResidencyBoundary = mapped
    }

    /**
     * @param value Data Residency Boundary of the resource.
     */
    @JvmName("nswojwshaxfrhbtn")
    public fun dataResidencyBoundary(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataResidencyBoundary>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataResidencyBoundary = mapped
    }

    /**
     * @param value Data Residency Boundary of the resource.
     */
    @JvmName("byrdqaeuxbwcownp")
    public fun dataResidencyBoundary(`value`: DataResidencyBoundary) {
        val toBeMapped = Either.ofRight<String, DataResidencyBoundary>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataResidencyBoundary = mapped
    }

    /**
     * @param value This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the domain.
     */
    @JvmName("opjratujjacffuba")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value Name of the domain.
     */
    @JvmName("fkjvetjfumdejejv")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Identity information for the Event Grid Domain resource.
     */
    @JvmName("futqkejpbxsfdiwv")
    public suspend fun identity(`value`: IdentityInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity information for the Event Grid Domain resource.
     */
    @JvmName("nshqfdakxkbxukeo")
    public suspend fun identity(argument: suspend IdentityInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("suqmgcyhynfjtrxb")
    public suspend fun inboundIpRules(`value`: List<InboundIpRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundIpRules = mapped
    }

    /**
     * @param argument This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("pgokxljjuxjlyxyu")
    public suspend fun inboundIpRules(argument: List<suspend InboundIpRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InboundIpRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundIpRules = mapped
    }

    /**
     * @param argument This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("cgeohepqgodpunlw")
    public suspend fun inboundIpRules(vararg argument: suspend InboundIpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InboundIpRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundIpRules = mapped
    }

    /**
     * @param argument This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("buujerqpgpptjpdv")
    public suspend fun inboundIpRules(argument: suspend InboundIpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InboundIpRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inboundIpRules = mapped
    }

    /**
     * @param values This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("trlbkncadljpawmt")
    public suspend fun inboundIpRules(vararg values: InboundIpRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inboundIpRules = mapped
    }

    /**
     * @param value This determines the format that Event Grid should expect for incoming events published to the Event Grid Domain Resource.
     */
    @JvmName("ddcgrhxylxttwsis")
    public suspend fun inputSchema(`value`: Either<String, InputSchema>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputSchema = mapped
    }

    /**
     * @param value This determines the format that Event Grid should expect for incoming events published to the Event Grid Domain Resource.
     */
    @JvmName("rpgertuexthnonxw")
    public fun inputSchema(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InputSchema>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputSchema = mapped
    }

    /**
     * @param value This determines the format that Event Grid should expect for incoming events published to the Event Grid Domain Resource.
     */
    @JvmName("xritcwpfcwxmhkpk")
    public fun inputSchema(`value`: InputSchema) {
        val toBeMapped = Either.ofRight<String, InputSchema>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputSchema = mapped
    }

    /**
     * @param value Information about the InputSchemaMapping which specified the info about mapping event payload.
     */
    @JvmName("kfkvhgyhkovulckg")
    public suspend fun inputSchemaMapping(`value`: JsonInputSchemaMappingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputSchemaMapping = mapped
    }

    /**
     * @param argument Information about the InputSchemaMapping which specified the info about mapping event payload.
     */
    @JvmName("nakhhdalnqftryre")
    public suspend
    fun inputSchemaMapping(argument: suspend JsonInputSchemaMappingArgsBuilder.() -> Unit) {
        val toBeMapped = JsonInputSchemaMappingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inputSchemaMapping = mapped
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("mxvolntuqxffuidn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules" />
     */
    @JvmName("xnxacgorhwmmpqag")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules" />
     */
    @JvmName("xnesscdjfljidpah")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules" />
     */
    @JvmName("bllogaocmnqkouwf")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("xmqbkdkjjpctlsoa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("jhdbvatfauhotlak")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags of the resource.
     */
    @JvmName("qpwqgsbnwdjkyulf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        autoCreateTopicWithFirstSubscription = autoCreateTopicWithFirstSubscription,
        autoDeleteTopicWithLastSubscription = autoDeleteTopicWithLastSubscription,
        dataResidencyBoundary = dataResidencyBoundary,
        disableLocalAuth = disableLocalAuth,
        domainName = domainName,
        identity = identity,
        inboundIpRules = inboundIpRules,
        inputSchema = inputSchema,
        inputSchemaMapping = inputSchemaMapping,
        location = location,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
