@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.IdentityInfoResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.InboundIpRuleResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.NamespaceSkuResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.TopicSpacesConfigurationResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.TopicsConfigurationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.eventgrid.kotlin.outputs.IdentityInfoResponse.Companion.toKotlin as identityInfoResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.InboundIpRuleResponse.Companion.toKotlin as inboundIpRuleResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.NamespaceSkuResponse.Companion.toKotlin as namespaceSkuResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.TopicSpacesConfigurationResponse.Companion.toKotlin as topicSpacesConfigurationResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.TopicsConfigurationResponse.Companion.toKotlin as topicsConfigurationResponseToKotlin

/**
 * Builder for [Namespace].
 */
@PulumiTagMarker
public class NamespaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamespaceArgs = NamespaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamespaceArgsBuilder.() -> Unit) {
        val builder = NamespaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Namespace {
        val builtJavaResource = com.pulumi.azurenative.eventgrid.Namespace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Namespace(builtJavaResource)
    }
}

/**
 * Namespace resource.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview.
 * ## Example Usage
 * ### Namespaces_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @namespace = new AzureNative.EventGrid.Namespace("namespace", new()
 *     {
 *         Location = "westus",
 *         NamespaceName = "exampleNamespaceName1",
 *         ResourceGroupName = "examplerg",
 *         Tags =
 *         {
 *             { "tag1", "value11" },
 *             { "tag2", "value22" },
 *         },
 *         TopicSpacesConfiguration = new AzureNative.EventGrid.Inputs.TopicSpacesConfigurationArgs
 *         {
 *             RouteTopicResourceId = "/subscriptions/8f6b6269-84f2-4d09-9e31-1127efcd1e40/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampleTopic1",
 *             State = AzureNative.EventGrid.TopicSpacesConfigurationState.Enabled,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewNamespace(ctx, "namespace", &eventgrid.NamespaceArgs{
 * 			Location:          pulumi.String("westus"),
 * 			NamespaceName:     pulumi.String("exampleNamespaceName1"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value11"),
 * 				"tag2": pulumi.String("value22"),
 * 			},
 * 			TopicSpacesConfiguration: &eventgrid.TopicSpacesConfigurationArgs{
 * 				RouteTopicResourceId: pulumi.String("/subscriptions/8f6b6269-84f2-4d09-9e31-1127efcd1e40/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampleTopic1"),
 * 				State:                pulumi.String(eventgrid.TopicSpacesConfigurationStateEnabled),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.Namespace;
 * import com.pulumi.azurenative.eventgrid.NamespaceArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.TopicSpacesConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespace = new Namespace("namespace", NamespaceArgs.builder()
 *             .location("westus")
 *             .namespaceName("exampleNamespaceName1")
 *             .resourceGroupName("examplerg")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value11"),
 *                 Map.entry("tag2", "value22")
 *             ))
 *             .topicSpacesConfiguration(TopicSpacesConfigurationArgs.builder()
 *                 .routeTopicResourceId("/subscriptions/8f6b6269-84f2-4d09-9e31-1127efcd1e40/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampleTopic1")
 *                 .state("Enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:Namespace exampleNamespaceName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}
 * ```
 */
public class Namespace internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.Namespace,
) : KotlinCustomResource(javaResource, NamespaceMapper) {
    /**
     * Identity information for the Namespace resource.
     */
    public val identity: Output<IdentityInfoResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    public val inboundIpRules: Output<List<InboundIpRuleResponse>>?
        get() = javaResource.inboundIpRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        inboundIpRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Allows the user to specify if the service is zone-redundant. This is a required property and user needs to specify this value explicitly.
     * Once specified, this property cannot be updated.
     */
    public val isZoneRedundant: Output<Boolean>?
        get() = javaResource.isZoneRedundant().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Location of the resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Minimum TLS version of the publisher allowed to publish to this namespace. Only TLS version 1.2 is supported.
     */
    public val minimumTlsVersionAllowed: Output<String>?
        get() = javaResource.minimumTlsVersionAllowed().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>?
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        privateEndpointConnectionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Provisioning state of the namespace resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules" />
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Represents available Sku pricing tiers.
     */
    public val sku: Output<NamespaceSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    namespaceSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The system metadata relating to the namespace resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Topic spaces configuration information for the namespace resource
     */
    public val topicSpacesConfiguration: Output<TopicSpacesConfigurationResponse>?
        get() = javaResource.topicSpacesConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> topicSpacesConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Topics configuration information for the namespace resource
     */
    public val topicsConfiguration: Output<TopicsConfigurationResponse>?
        get() = javaResource.topicsConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> topicsConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NamespaceMapper : ResourceMapper<Namespace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.Namespace::class == javaResource::class

    override fun map(javaResource: Resource): Namespace = Namespace(
        javaResource as
            com.pulumi.azurenative.eventgrid.Namespace,
    )
}

/**
 * @see [Namespace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Namespace].
 */
public suspend fun namespace(name: String, block: suspend NamespaceResourceBuilder.() -> Unit):
    Namespace {
    val builder = NamespaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Namespace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namespace(name: String): Namespace {
    val builder = NamespaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
