@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.DeliveryConfigurationResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.FiltersConfigurationResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.eventgrid.kotlin.outputs.DeliveryConfigurationResponse.Companion.toKotlin as deliveryConfigurationResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.FiltersConfigurationResponse.Companion.toKotlin as filtersConfigurationResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NamespaceTopicEventSubscription].
 */
@PulumiTagMarker
public class NamespaceTopicEventSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamespaceTopicEventSubscriptionArgs = NamespaceTopicEventSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamespaceTopicEventSubscriptionArgsBuilder.() -> Unit) {
        val builder = NamespaceTopicEventSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NamespaceTopicEventSubscription {
        val builtJavaResource =
            com.pulumi.azurenative.eventgrid.NamespaceTopicEventSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NamespaceTopicEventSubscription(builtJavaResource)
    }
}

/**
 * Event Subscription.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview.
 * ## Example Usage
 * ### NamespaceTopicEventSubscriptions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceTopicEventSubscription = new AzureNative.EventGrid.NamespaceTopicEventSubscription("namespaceTopicEventSubscription", new()
 *     {
 *         DeliveryConfiguration = new AzureNative.EventGrid.Inputs.DeliveryConfigurationArgs
 *         {
 *             DeliveryMode = AzureNative.EventGrid.DeliveryMode.Queue,
 *             Queue = new AzureNative.EventGrid.Inputs.QueueInfoArgs
 *             {
 *                 EventTimeToLive = "P1D",
 *                 MaxDeliveryCount = 4,
 *                 ReceiveLockDurationInSeconds = 60,
 *             },
 *         },
 *         EventDeliverySchema = AzureNative.EventGrid.DeliverySchema.CloudEventSchemaV1_0,
 *         EventSubscriptionName = "examplenamespacetopicEventSub2",
 *         NamespaceName = "examplenamespace2",
 *         ResourceGroupName = "examplerg",
 *         TopicName = "examplenamespacetopic2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewNamespaceTopicEventSubscription(ctx, "namespaceTopicEventSubscription", &eventgrid.NamespaceTopicEventSubscriptionArgs{
 * 			DeliveryConfiguration: &eventgrid.DeliveryConfigurationArgs{
 * 				DeliveryMode: pulumi.String(eventgrid.DeliveryModeQueue),
 * 				Queue: &eventgrid.QueueInfoArgs{
 * 					EventTimeToLive:              pulumi.String("P1D"),
 * 					MaxDeliveryCount:             pulumi.Int(4),
 * 					ReceiveLockDurationInSeconds: pulumi.Int(60),
 * 				},
 * 			},
 * 			EventDeliverySchema:   pulumi.String(eventgrid.DeliverySchema_CloudEventSchemaV1_0),
 * 			EventSubscriptionName: pulumi.String("examplenamespacetopicEventSub2"),
 * 			NamespaceName:         pulumi.String("examplenamespace2"),
 * 			ResourceGroupName:     pulumi.String("examplerg"),
 * 			TopicName:             pulumi.String("examplenamespacetopic2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.NamespaceTopicEventSubscription;
 * import com.pulumi.azurenative.eventgrid.NamespaceTopicEventSubscriptionArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.DeliveryConfigurationArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.QueueInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceTopicEventSubscription = new NamespaceTopicEventSubscription("namespaceTopicEventSubscription", NamespaceTopicEventSubscriptionArgs.builder()
 *             .deliveryConfiguration(DeliveryConfigurationArgs.builder()
 *                 .deliveryMode("Queue")
 *                 .queue(QueueInfoArgs.builder()
 *                     .eventTimeToLive("P1D")
 *                     .maxDeliveryCount(4)
 *                     .receiveLockDurationInSeconds(60)
 *                     .build())
 *                 .build())
 *             .eventDeliverySchema("CloudEventSchemaV1_0")
 *             .eventSubscriptionName("examplenamespacetopicEventSub2")
 *             .namespaceName("examplenamespace2")
 *             .resourceGroupName("examplerg")
 *             .topicName("examplenamespacetopic2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:NamespaceTopicEventSubscription examplenamespacetopicEventSub2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}
 * ```
 */
public class NamespaceTopicEventSubscription internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.NamespaceTopicEventSubscription,
) : KotlinCustomResource(javaResource, NamespaceTopicEventSubscriptionMapper) {
    /**
     * Information about the delivery configuration of the event subscription.
     */
    public val deliveryConfiguration: Output<DeliveryConfigurationResponse>?
        get() = javaResource.deliveryConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deliveryConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The event delivery schema for the event subscription.
     */
    public val eventDeliverySchema: Output<String>?
        get() = javaResource.eventDeliverySchema().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Information about the filter for the event subscription.
     */
    public val filtersConfiguration: Output<FiltersConfigurationResponse>?
        get() = javaResource.filtersConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> filtersConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the event subscription.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The system metadata relating to Event Subscription resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NamespaceTopicEventSubscriptionMapper :
    ResourceMapper<NamespaceTopicEventSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.NamespaceTopicEventSubscription::class == javaResource::class

    override fun map(javaResource: Resource): NamespaceTopicEventSubscription =
        NamespaceTopicEventSubscription(
            javaResource as
                com.pulumi.azurenative.eventgrid.NamespaceTopicEventSubscription,
        )
}

/**
 * @see [NamespaceTopicEventSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NamespaceTopicEventSubscription].
 */
public suspend fun namespaceTopicEventSubscription(
    name: String,
    block: suspend NamespaceTopicEventSubscriptionResourceBuilder.() -> Unit,
):
    NamespaceTopicEventSubscription {
    val builder = NamespaceTopicEventSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NamespaceTopicEventSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namespaceTopicEventSubscription(name: String): NamespaceTopicEventSubscription {
    val builder = NamespaceTopicEventSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
