@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.ConnectionStateResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.eventgrid.kotlin.outputs.ConnectionStateResponse.Companion.toKotlin as connectionStateResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin

/**
 * Builder for [PrivateEndpointConnection].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.eventgrid.PrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateEndpointConnection(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
 * ## Example Usage
 * ### PrivateEndpointConnections_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.EventGrid.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         ParentName = "exampletopic1",
 *         ParentType = "topics",
 *         PrivateEndpointConnectionName = "BMTPE5.8A30D251-4C61-489D-A1AA-B37C4A329B8B",
 *         PrivateLinkServiceConnectionState = new AzureNative.EventGrid.Inputs.ConnectionStateArgs
 *         {
 *             ActionsRequired = "None",
 *             Description = "approving connection",
 *             Status = AzureNative.EventGrid.PersistedConnectionStatus.Approved,
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &eventgrid.PrivateEndpointConnectionArgs{
 * 			ParentName:                    pulumi.String("exampletopic1"),
 * 			ParentType:                    pulumi.String("topics"),
 * 			PrivateEndpointConnectionName: pulumi.String("BMTPE5.8A30D251-4C61-489D-A1AA-B37C4A329B8B"),
 * 			PrivateLinkServiceConnectionState: &eventgrid.ConnectionStateArgs{
 * 				ActionsRequired: pulumi.String("None"),
 * 				Description:     pulumi.String("approving connection"),
 * 				Status:          pulumi.String(eventgrid.PersistedConnectionStatusApproved),
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.PrivateEndpointConnection;
 * import com.pulumi.azurenative.eventgrid.PrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.ConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .parentName("exampletopic1")
 *             .parentType("topics")
 *             .privateEndpointConnectionName("BMTPE5.8A30D251-4C61-489D-A1AA-B37C4A329B8B")
 *             .privateLinkServiceConnectionState(ConnectionStateArgs.builder()
 *                 .actionsRequired("None")
 *                 .description("approving connection")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:PrivateEndpointConnection BMTPE5.8A30D251-4C61-489D-A1AA-B37C4A329B8B /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/{parentType}/{parentName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class PrivateEndpointConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.PrivateEndpointConnection,
) : KotlinCustomResource(javaResource, PrivateEndpointConnectionMapper) {
    /**
     * GroupIds from the private link service resource.
     */
    public val groupIds: Output<List<String>>?
        get() = javaResource.groupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Private Endpoint resource for this Connection.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Details about the state of the connection.
     */
    public val privateLinkServiceConnectionState: Output<ConnectionStateResponse>?
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    connectionStateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Provisioning state of the Private Endpoint Connection.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointConnectionMapper : ResourceMapper<PrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.PrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpointConnection =
        PrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.eventgrid.PrivateEndpointConnection,
        )
}

/**
 * @see [PrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpointConnection].
 */
public suspend fun privateEndpointConnection(
    name: String,
    block: suspend PrivateEndpointConnectionResourceBuilder.() -> Unit,
): PrivateEndpointConnection {
    val builder = PrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpointConnection(name: String): PrivateEndpointConnection {
    val builder = PrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
