@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.IdentityInfoResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.InboundIpRuleResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.JsonInputSchemaMappingResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.eventgrid.kotlin.outputs.IdentityInfoResponse.Companion.toKotlin as identityInfoResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.InboundIpRuleResponse.Companion.toKotlin as inboundIpRuleResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.JsonInputSchemaMappingResponse.Companion.toKotlin as jsonInputSchemaMappingResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Topic].
 */
@PulumiTagMarker
public class TopicResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TopicArgs = TopicArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TopicArgsBuilder.() -> Unit) {
        val builder = TopicArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Topic {
        val builtJavaResource = com.pulumi.azurenative.eventgrid.Topic(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Topic(builtJavaResource)
    }
}

/**
 * EventGrid Topic
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2020-04-01-preview, 2023-06-01-preview, 2023-12-15-preview.
 * ## Example Usage
 * ### Topics_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var topic = new AzureNative.EventGrid.Topic("topic", new()
 *     {
 *         InboundIpRules = new[]
 *         {
 *             new AzureNative.EventGrid.Inputs.InboundIpRuleArgs
 *             {
 *                 Action = AzureNative.EventGrid.IpActionType.Allow,
 *                 IpMask = "12.18.30.15",
 *             },
 *             new AzureNative.EventGrid.Inputs.InboundIpRuleArgs
 *             {
 *                 Action = AzureNative.EventGrid.IpActionType.Allow,
 *                 IpMask = "12.18.176.1",
 *             },
 *         },
 *         Location = "westus2",
 *         PublicNetworkAccess = AzureNative.EventGrid.PublicNetworkAccess.Enabled,
 *         ResourceGroupName = "examplerg",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *         TopicName = "exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewTopic(ctx, "topic", &eventgrid.TopicArgs{
 * 			InboundIpRules: eventgrid.InboundIpRuleArray{
 * 				&eventgrid.InboundIpRuleArgs{
 * 					Action: pulumi.String(eventgrid.IpActionTypeAllow),
 * 					IpMask: pulumi.String("12.18.30.15"),
 * 				},
 * 				&eventgrid.InboundIpRuleArgs{
 * 					Action: pulumi.String(eventgrid.IpActionTypeAllow),
 * 					IpMask: pulumi.String("12.18.176.1"),
 * 				},
 * 			},
 * 			Location:            pulumi.String("westus2"),
 * 			PublicNetworkAccess: pulumi.String(eventgrid.PublicNetworkAccessEnabled),
 * 			ResourceGroupName:   pulumi.String("examplerg"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 			TopicName: pulumi.String("exampletopic1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.Topic;
 * import com.pulumi.azurenative.eventgrid.TopicArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.InboundIpRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var topic = new Topic("topic", TopicArgs.builder()
 *             .inboundIpRules(
 *                 InboundIpRuleArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("12.18.30.15")
 *                     .build(),
 *                 InboundIpRuleArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("12.18.176.1")
 *                     .build())
 *             .location("westus2")
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("examplerg")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .topicName("exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:Topic exampletopic1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}
 * ```
 */
public class Topic internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.Topic,
) : KotlinCustomResource(javaResource, TopicMapper) {
    /**
     * Data Residency Boundary of the resource.
     */
    public val dataResidencyBoundary: Output<String>?
        get() = javaResource.dataResidencyBoundary().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the topic.
     */
    public val disableLocalAuth: Output<Boolean>?
        get() = javaResource.disableLocalAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Endpoint for the topic.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * Identity information for the resource.
     */
    public val identity: Output<IdentityInfoResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    public val inboundIpRules: Output<List<InboundIpRuleResponse>>?
        get() = javaResource.inboundIpRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        inboundIpRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * This determines the format that Event Grid should expect for incoming events published to the topic.
     */
    public val inputSchema: Output<String>?
        get() = javaResource.inputSchema().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This enables publishing using custom event schemas. An InputSchemaMapping can be specified to map various properties of a source schema to various required properties of the EventGridEvent schema.
     */
    public val inputSchemaMapping: Output<JsonInputSchemaMappingResponse>?
        get() = javaResource.inputSchemaMapping().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> jsonInputSchemaMappingResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Location of the resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Metric resource id for the topic.
     */
    public val metricResourceId: Output<String>
        get() = javaResource.metricResourceId().applyValue({ args0 -> args0 })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Provisioning state of the topic.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules" />
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata relating to Topic resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TopicMapper : ResourceMapper<Topic> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.Topic::class == javaResource::class

    override fun map(javaResource: Resource): Topic = Topic(
        javaResource as
            com.pulumi.azurenative.eventgrid.Topic,
    )
}

/**
 * @see [Topic].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Topic].
 */
public suspend fun topic(name: String, block: suspend TopicResourceBuilder.() -> Unit): Topic {
    val builder = TopicResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Topic].
 * @param name The _unique_ name of the resulting resource.
 */
public fun topic(name: String): Topic {
    val builder = TopicResourceBuilder()
    builder.name(name)
    return builder.build()
}
