@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [TopicSpace].
 */
@PulumiTagMarker
public class TopicSpaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TopicSpaceArgs = TopicSpaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TopicSpaceArgsBuilder.() -> Unit) {
        val builder = TopicSpaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TopicSpace {
        val builtJavaResource = com.pulumi.azurenative.eventgrid.TopicSpace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TopicSpace(builtJavaResource)
    }
}

/**
 * The Topic space resource.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview.
 * ## Example Usage
 * ### TopicSpaces_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var topicSpace = new AzureNative.EventGrid.TopicSpace("topicSpace", new()
 *     {
 *         NamespaceName = "exampleNamespaceName1",
 *         ResourceGroupName = "examplerg",
 *         TopicSpaceName = "exampleTopicSpaceName1",
 *         TopicTemplates = new[]
 *         {
 *             "filter1",
 *             "filter2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewTopicSpace(ctx, "topicSpace", &eventgrid.TopicSpaceArgs{
 * 			NamespaceName:     pulumi.String("exampleNamespaceName1"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			TopicSpaceName:    pulumi.String("exampleTopicSpaceName1"),
 * 			TopicTemplates: pulumi.StringArray{
 * 				pulumi.String("filter1"),
 * 				pulumi.String("filter2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.TopicSpace;
 * import com.pulumi.azurenative.eventgrid.TopicSpaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var topicSpace = new TopicSpace("topicSpace", TopicSpaceArgs.builder()
 *             .namespaceName("exampleNamespaceName1")
 *             .resourceGroupName("examplerg")
 *             .topicSpaceName("exampleTopicSpaceName1")
 *             .topicTemplates(
 *                 "filter1",
 *                 "filter2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:TopicSpace exampleTopicSpaceName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topicSpaces/{topicSpaceName}
 * ```
 */
public class TopicSpace internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.TopicSpace,
) : KotlinCustomResource(javaResource, TopicSpaceMapper) {
    /**
     * Description for the Topic Space resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the TopicSpace resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The system metadata relating to the TopicSpace resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The topic filters in the topic space.
     * Example: "topicTemplates": [
     *               "devices/foo/bar",
     *               "devices/topic1/+",
     *               "devices/${principal.name}/${principal.attributes.keyName}" ].
     */
    public val topicTemplates: Output<List<String>>?
        get() = javaResource.topicTemplates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TopicSpaceMapper : ResourceMapper<TopicSpace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.TopicSpace::class == javaResource::class

    override fun map(javaResource: Resource): TopicSpace = TopicSpace(
        javaResource as
            com.pulumi.azurenative.eventgrid.TopicSpace,
    )
}

/**
 * @see [TopicSpace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TopicSpace].
 */
public suspend fun topicSpace(name: String, block: suspend TopicSpaceResourceBuilder.() -> Unit):
    TopicSpace {
    val builder = TopicSpaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TopicSpace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun topicSpace(name: String): TopicSpace {
    val builder = TopicSpaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
