@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
 */
public enum class EventSubscriptionIdentityType(
    public val javaValue: com.pulumi.azurenative.eventgrid.enums.EventSubscriptionIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.enums.EventSubscriptionIdentityType> {
    SystemAssigned(com.pulumi.azurenative.eventgrid.enums.EventSubscriptionIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.eventgrid.enums.EventSubscriptionIdentityType.UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.eventgrid.enums.EventSubscriptionIdentityType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.enums.EventSubscriptionIdentityType):
            EventSubscriptionIdentityType =
            EventSubscriptionIdentityType.values().first { it.javaValue == javaType }
    }
}
