@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Provisioning state of the Private Endpoint Connection.
 */
public enum class ResourceProvisioningState(
    public val javaValue: com.pulumi.azurenative.eventgrid.enums.ResourceProvisioningState,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.enums.ResourceProvisioningState> {
    Creating(com.pulumi.azurenative.eventgrid.enums.ResourceProvisioningState.Creating),
    Updating(com.pulumi.azurenative.eventgrid.enums.ResourceProvisioningState.Updating),
    Deleting(com.pulumi.azurenative.eventgrid.enums.ResourceProvisioningState.Deleting),
    Succeeded(com.pulumi.azurenative.eventgrid.enums.ResourceProvisioningState.Succeeded),
    Canceled(com.pulumi.azurenative.eventgrid.enums.ResourceProvisioningState.Canceled),
    Failed(com.pulumi.azurenative.eventgrid.enums.ResourceProvisioningState.Failed),
    ;

    override fun toJava(): com.pulumi.azurenative.eventgrid.enums.ResourceProvisioningState =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.enums.ResourceProvisioningState):
            ResourceProvisioningState =
            ResourceProvisioningState.values().first { it.javaValue == javaType }
    }
}
