@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.DeliveryWithResourceIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Information about the delivery for an event subscription with resource identity.
 * @property destination Information about the destination where events have to be delivered for the event subscription.
 * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property identity The identity to use when delivering events.
 */
public data class DeliveryWithResourceIdentityArgs(
    public val destination: Output<Any>? = null,
    public val identity: Output<EventSubscriptionIdentityArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.DeliveryWithResourceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.DeliveryWithResourceIdentityArgs =
        com.pulumi.azurenative.eventgrid.inputs.DeliveryWithResourceIdentityArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryWithResourceIdentityArgs].
 */
@PulumiTagMarker
public class DeliveryWithResourceIdentityArgsBuilder internal constructor() {
    private var destination: Output<Any>? = null

    private var identity: Output<EventSubscriptionIdentityArgs>? = null

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("omoskwildbtfhbcw")
    public suspend fun destination(`value`: Output<Any>) {
        this.destination = value
    }

    /**
     * @param value The identity to use when delivering events.
     */
    @JvmName("ltktmcgjfhpiyamw")
    public suspend fun identity(`value`: Output<EventSubscriptionIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("qiwvefgtsicaneti")
    public suspend fun destination(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value The identity to use when delivering events.
     */
    @JvmName("bfapgdnmayfjoiwn")
    public suspend fun identity(`value`: EventSubscriptionIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity to use when delivering events.
     */
    @JvmName("sblppevlperxdtmd")
    public suspend fun identity(argument: suspend EventSubscriptionIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = EventSubscriptionIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    internal fun build(): DeliveryWithResourceIdentityArgs = DeliveryWithResourceIdentityArgs(
        destination = destination,
        identity = identity,
    )
}
