@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.EventTypeInfoArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.EventDefinitionKind
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The event type information for Channels.
 * @property inlineEventTypes A collection of inline event types for the resource. The inline event type keys are of type string which represents the name of the event.
 * An example of a valid inline event name is "Contoso.OrderCreated".
 * The inline event type values are of type InlineEventProperties and will contain additional information for every inline event type.
 * @property kind The kind of event type used.
 */
public data class EventTypeInfoArgs(
    public val inlineEventTypes: Output<Map<String, InlineEventPropertiesArgs>>? = null,
    public val kind: Output<Either<String, EventDefinitionKind>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.EventTypeInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.EventTypeInfoArgs =
        com.pulumi.azurenative.eventgrid.inputs.EventTypeInfoArgs.builder()
            .inlineEventTypes(
                inlineEventTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EventTypeInfoArgs].
 */
@PulumiTagMarker
public class EventTypeInfoArgsBuilder internal constructor() {
    private var inlineEventTypes: Output<Map<String, InlineEventPropertiesArgs>>? = null

    private var kind: Output<Either<String, EventDefinitionKind>>? = null

    /**
     * @param value A collection of inline event types for the resource. The inline event type keys are of type string which represents the name of the event.
     * An example of a valid inline event name is "Contoso.OrderCreated".
     * The inline event type values are of type InlineEventProperties and will contain additional information for every inline event type.
     */
    @JvmName("uvunwkiyjdtoccyy")
    public suspend fun inlineEventTypes(`value`: Output<Map<String, InlineEventPropertiesArgs>>) {
        this.inlineEventTypes = value
    }

    /**
     * @param value The kind of event type used.
     */
    @JvmName("ebgnenkravxnqigj")
    public suspend fun kind(`value`: Output<Either<String, EventDefinitionKind>>) {
        this.kind = value
    }

    /**
     * @param value A collection of inline event types for the resource. The inline event type keys are of type string which represents the name of the event.
     * An example of a valid inline event name is "Contoso.OrderCreated".
     * The inline event type values are of type InlineEventProperties and will contain additional information for every inline event type.
     */
    @JvmName("gwkoectespotnqvq")
    public suspend fun inlineEventTypes(`value`: Map<String, InlineEventPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inlineEventTypes = mapped
    }

    /**
     * @param argument A collection of inline event types for the resource. The inline event type keys are of type string which represents the name of the event.
     * An example of a valid inline event name is "Contoso.OrderCreated".
     * The inline event type values are of type InlineEventProperties and will contain additional information for every inline event type.
     */
    @JvmName("htptsulanasytsqx")
    public suspend fun inlineEventTypes(
        vararg
        argument: Pair<String, suspend InlineEventPropertiesArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                InlineEventPropertiesArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.inlineEventTypes = mapped
    }

    /**
     * @param values A collection of inline event types for the resource. The inline event type keys are of type string which represents the name of the event.
     * An example of a valid inline event name is "Contoso.OrderCreated".
     * The inline event type values are of type InlineEventProperties and will contain additional information for every inline event type.
     */
    @JvmName("avceurxgcclgqhyr")
    public fun inlineEventTypes(vararg values: Pair<String, InlineEventPropertiesArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inlineEventTypes = mapped
    }

    /**
     * @param value The kind of event type used.
     */
    @JvmName("fokthyhodcjnynci")
    public suspend fun kind(`value`: Either<String, EventDefinitionKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of event type used.
     */
    @JvmName("qllbqrikghyuyylp")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventDefinitionKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of event type used.
     */
    @JvmName("yuriauagxgjnlidr")
    public fun kind(`value`: EventDefinitionKind) {
        val toBeMapped = Either.ofRight<String, EventDefinitionKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    internal fun build(): EventTypeInfoArgs = EventTypeInfoArgs(
        inlineEventTypes = inlineEventTypes,
        kind = kind,
    )
}
