@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetCaCertificatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property caCertificateName Name of the CA certificate.
 * @property namespaceName Name of the namespace.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class GetCaCertificatePlainArgs(
    public val caCertificateName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetCaCertificatePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetCaCertificatePlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetCaCertificatePlainArgs.builder()
            .caCertificateName(caCertificateName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCaCertificatePlainArgs].
 */
@PulumiTagMarker
public class GetCaCertificatePlainArgsBuilder internal constructor() {
    private var caCertificateName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the CA certificate.
     */
    @JvmName("xxmqvhratvoqemhk")
    public suspend fun caCertificateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.caCertificateName = mapped
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("bfrxmvsilfmyfmkg")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("urqcrkbmwwmdfctx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCaCertificatePlainArgs = GetCaCertificatePlainArgs(
        caCertificateName = caCertificateName ?: throw PulumiNullFieldException("caCertificateName"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
