@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetDomainEventSubscriptionDeliveryAttributesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName Name of the domain topic.
 * @property eventSubscriptionName Name of the event subscription.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class GetDomainEventSubscriptionDeliveryAttributesPlainArgs(
    public val domainName: String,
    public val eventSubscriptionName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetDomainEventSubscriptionDeliveryAttributesPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventgrid.inputs.GetDomainEventSubscriptionDeliveryAttributesPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetDomainEventSubscriptionDeliveryAttributesPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .eventSubscriptionName(eventSubscriptionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainEventSubscriptionDeliveryAttributesPlainArgs].
 */
@PulumiTagMarker
public class GetDomainEventSubscriptionDeliveryAttributesPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var eventSubscriptionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the domain topic.
     */
    @JvmName("ninhxgrtpdiotqvv")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value Name of the event subscription.
     */
    @JvmName("smyfnjigjsdwrjni")
    public suspend fun eventSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventSubscriptionName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("lbyjmvdxqrvfxymw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDomainEventSubscriptionDeliveryAttributesPlainArgs =
        GetDomainEventSubscriptionDeliveryAttributesPlainArgs(
            domainName = domainName ?: throw PulumiNullFieldException("domainName"),
            eventSubscriptionName = eventSubscriptionName ?: throw
                PulumiNullFieldException("eventSubscriptionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
