@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetDomainEventSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName Name of the partner topic.
 * @property eventSubscriptionName Name of the event subscription to be found. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class GetDomainEventSubscriptionPlainArgs(
    public val domainName: String,
    public val eventSubscriptionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetDomainEventSubscriptionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetDomainEventSubscriptionPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetDomainEventSubscriptionPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .eventSubscriptionName(eventSubscriptionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainEventSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetDomainEventSubscriptionPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var eventSubscriptionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the partner topic.
     */
    @JvmName("cegtfgxxbdxamrms")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value Name of the event subscription to be found. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     */
    @JvmName("svtbokoodynaixmn")
    public suspend fun eventSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventSubscriptionName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("yrorehfnykqcpxhs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDomainEventSubscriptionPlainArgs = GetDomainEventSubscriptionPlainArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        eventSubscriptionName = eventSubscriptionName ?: throw
            PulumiNullFieldException("eventSubscriptionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
