@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetNamespaceTopicEventSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventSubscriptionName Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
 * @property namespaceName Name of the namespace.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property topicName Name of the namespace topic.
 */
public data class GetNamespaceTopicEventSubscriptionPlainArgs(
    public val eventSubscriptionName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
    public val topicName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetNamespaceTopicEventSubscriptionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventgrid.inputs.GetNamespaceTopicEventSubscriptionPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetNamespaceTopicEventSubscriptionPlainArgs.builder()
            .eventSubscriptionName(eventSubscriptionName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .topicName(topicName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNamespaceTopicEventSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetNamespaceTopicEventSubscriptionPlainArgsBuilder internal constructor() {
    private var eventSubscriptionName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    private var topicName: String? = null

    /**
     * @param value Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     */
    @JvmName("geguqvlvmtwvlpua")
    public suspend fun eventSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventSubscriptionName = mapped
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("lbuypsoasupinfwq")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("hnmwvrgiadddijlj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the namespace topic.
     */
    @JvmName("wmxlxelfiqvrtrph")
    public suspend fun topicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicName = mapped
    }

    internal fun build(): GetNamespaceTopicEventSubscriptionPlainArgs =
        GetNamespaceTopicEventSubscriptionPlainArgs(
            eventSubscriptionName = eventSubscriptionName ?: throw
                PulumiNullFieldException("eventSubscriptionName"),
            namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            topicName = topicName ?: throw PulumiNullFieldException("topicName"),
        )
}
