@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetPartnerConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class GetPartnerConfigurationPlainArgs(
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetPartnerConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetPartnerConfigurationPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetPartnerConfigurationPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPartnerConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetPartnerConfigurationPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("hsjytnhrcdcliejb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPartnerConfigurationPlainArgs = GetPartnerConfigurationPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
