@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetPartnerNamespacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property partnerNamespaceName Name of the partner namespace.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class GetPartnerNamespacePlainArgs(
    public val partnerNamespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetPartnerNamespacePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetPartnerNamespacePlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetPartnerNamespacePlainArgs.builder()
            .partnerNamespaceName(partnerNamespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPartnerNamespacePlainArgs].
 */
@PulumiTagMarker
public class GetPartnerNamespacePlainArgsBuilder internal constructor() {
    private var partnerNamespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the partner namespace.
     */
    @JvmName("fqayyycwdrrpvems")
    public suspend fun partnerNamespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.partnerNamespaceName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("jwjsyoqgsriixnnv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPartnerNamespacePlainArgs = GetPartnerNamespacePlainArgs(
        partnerNamespaceName = partnerNamespaceName ?: throw
            PulumiNullFieldException("partnerNamespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
