@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetTopicEventSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventSubscriptionName Name of the event subscription to be found. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property topicName Name of the partner topic.
 */
public data class GetTopicEventSubscriptionPlainArgs(
    public val eventSubscriptionName: String,
    public val resourceGroupName: String,
    public val topicName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetTopicEventSubscriptionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetTopicEventSubscriptionPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetTopicEventSubscriptionPlainArgs.builder()
            .eventSubscriptionName(eventSubscriptionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .topicName(topicName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTopicEventSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetTopicEventSubscriptionPlainArgsBuilder internal constructor() {
    private var eventSubscriptionName: String? = null

    private var resourceGroupName: String? = null

    private var topicName: String? = null

    /**
     * @param value Name of the event subscription to be found. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     */
    @JvmName("ofvusrmmbxvfbrrb")
    public suspend fun eventSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventSubscriptionName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("lsxbpmbsvcetodar")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the partner topic.
     */
    @JvmName("mpcmxbmenxdpadoc")
    public suspend fun topicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicName = mapped
    }

    internal fun build(): GetTopicEventSubscriptionPlainArgs = GetTopicEventSubscriptionPlainArgs(
        eventSubscriptionName = eventSubscriptionName ?: throw
            PulumiNullFieldException("eventSubscriptionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        topicName = topicName ?: throw PulumiNullFieldException("topicName"),
    )
}
