@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.InlineEventPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Additional information about every inline event.
 * @property dataSchemaUrl The dataSchemaUrl for the inline event.
 * @property description The description for the inline event.
 * @property displayName The displayName for the inline event.
 * @property documentationUrl The documentationUrl for the inline event.
 */
public data class InlineEventPropertiesArgs(
    public val dataSchemaUrl: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val documentationUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.InlineEventPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.InlineEventPropertiesArgs =
        com.pulumi.azurenative.eventgrid.inputs.InlineEventPropertiesArgs.builder()
            .dataSchemaUrl(dataSchemaUrl?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .documentationUrl(documentationUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InlineEventPropertiesArgs].
 */
@PulumiTagMarker
public class InlineEventPropertiesArgsBuilder internal constructor() {
    private var dataSchemaUrl: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var documentationUrl: Output<String>? = null

    /**
     * @param value The dataSchemaUrl for the inline event.
     */
    @JvmName("bxgqxceoxxltumes")
    public suspend fun dataSchemaUrl(`value`: Output<String>) {
        this.dataSchemaUrl = value
    }

    /**
     * @param value The description for the inline event.
     */
    @JvmName("otwduvquntaijjlv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The displayName for the inline event.
     */
    @JvmName("ygqqblnkcnbglden")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The documentationUrl for the inline event.
     */
    @JvmName("kbsiejpcqktyjknf")
    public suspend fun documentationUrl(`value`: Output<String>) {
        this.documentationUrl = value
    }

    /**
     * @param value The dataSchemaUrl for the inline event.
     */
    @JvmName("ynichpmpdskoqhuw")
    public suspend fun dataSchemaUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSchemaUrl = mapped
    }

    /**
     * @param value The description for the inline event.
     */
    @JvmName("ckdyqayjloodhemy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The displayName for the inline event.
     */
    @JvmName("ejvssifbjiadbhtw")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The documentationUrl for the inline event.
     */
    @JvmName("gmecnkgopswtjltx")
    public suspend fun documentationUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentationUrl = mapped
    }

    internal fun build(): InlineEventPropertiesArgs = InlineEventPropertiesArgs(
        dataSchemaUrl = dataSchemaUrl,
        description = description,
        displayName = displayName,
        documentationUrl = documentationUrl,
    )
}
