@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.JsonInputSchemaMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * This enables publishing to Event Grid using a custom input schema. This can be used to map properties from a custom input JSON schema to the Event Grid event schema.
 * @property dataVersion The mapping information for the DataVersion property of the Event Grid Event.
 * @property eventTime The mapping information for the EventTime property of the Event Grid Event.
 * @property eventType The mapping information for the EventType property of the Event Grid Event.
 * @property id The mapping information for the Id property of the Event Grid Event.
 * @property inputSchemaMappingType Type of the custom mapping
 * Expected value is 'Json'.
 * @property subject The mapping information for the Subject property of the Event Grid Event.
 * @property topic The mapping information for the Topic property of the Event Grid Event.
 */
public data class JsonInputSchemaMappingArgs(
    public val dataVersion: Output<JsonFieldWithDefaultArgs>? = null,
    public val eventTime: Output<JsonFieldArgs>? = null,
    public val eventType: Output<JsonFieldWithDefaultArgs>? = null,
    public val id: Output<JsonFieldArgs>? = null,
    public val inputSchemaMappingType: Output<String>,
    public val subject: Output<JsonFieldWithDefaultArgs>? = null,
    public val topic: Output<JsonFieldArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.JsonInputSchemaMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.JsonInputSchemaMappingArgs =
        com.pulumi.azurenative.eventgrid.inputs.JsonInputSchemaMappingArgs.builder()
            .dataVersion(dataVersion?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventTime(eventTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventType(eventType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inputSchemaMappingType(inputSchemaMappingType.applyValue({ args0 -> args0 }))
            .subject(subject?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .topic(topic?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [JsonInputSchemaMappingArgs].
 */
@PulumiTagMarker
public class JsonInputSchemaMappingArgsBuilder internal constructor() {
    private var dataVersion: Output<JsonFieldWithDefaultArgs>? = null

    private var eventTime: Output<JsonFieldArgs>? = null

    private var eventType: Output<JsonFieldWithDefaultArgs>? = null

    private var id: Output<JsonFieldArgs>? = null

    private var inputSchemaMappingType: Output<String>? = null

    private var subject: Output<JsonFieldWithDefaultArgs>? = null

    private var topic: Output<JsonFieldArgs>? = null

    /**
     * @param value The mapping information for the DataVersion property of the Event Grid Event.
     */
    @JvmName("oslycwdhuwpgxnue")
    public suspend fun dataVersion(`value`: Output<JsonFieldWithDefaultArgs>) {
        this.dataVersion = value
    }

    /**
     * @param value The mapping information for the EventTime property of the Event Grid Event.
     */
    @JvmName("bcpnqjelrkeoudjf")
    public suspend fun eventTime(`value`: Output<JsonFieldArgs>) {
        this.eventTime = value
    }

    /**
     * @param value The mapping information for the EventType property of the Event Grid Event.
     */
    @JvmName("rupvvpugmmfdello")
    public suspend fun eventType(`value`: Output<JsonFieldWithDefaultArgs>) {
        this.eventType = value
    }

    /**
     * @param value The mapping information for the Id property of the Event Grid Event.
     */
    @JvmName("ectsmdrgxcdopxre")
    public suspend fun id(`value`: Output<JsonFieldArgs>) {
        this.id = value
    }

    /**
     * @param value Type of the custom mapping
     * Expected value is 'Json'.
     */
    @JvmName("rhlasbwwqdvcpryi")
    public suspend fun inputSchemaMappingType(`value`: Output<String>) {
        this.inputSchemaMappingType = value
    }

    /**
     * @param value The mapping information for the Subject property of the Event Grid Event.
     */
    @JvmName("myelemarljeruerk")
    public suspend fun subject(`value`: Output<JsonFieldWithDefaultArgs>) {
        this.subject = value
    }

    /**
     * @param value The mapping information for the Topic property of the Event Grid Event.
     */
    @JvmName("rjqluamtnlmgyocq")
    public suspend fun topic(`value`: Output<JsonFieldArgs>) {
        this.topic = value
    }

    /**
     * @param value The mapping information for the DataVersion property of the Event Grid Event.
     */
    @JvmName("thmelubmtdockfab")
    public suspend fun dataVersion(`value`: JsonFieldWithDefaultArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataVersion = mapped
    }

    /**
     * @param argument The mapping information for the DataVersion property of the Event Grid Event.
     */
    @JvmName("kxlglunykmawpvjh")
    public suspend fun dataVersion(argument: suspend JsonFieldWithDefaultArgsBuilder.() -> Unit) {
        val toBeMapped = JsonFieldWithDefaultArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataVersion = mapped
    }

    /**
     * @param value The mapping information for the EventTime property of the Event Grid Event.
     */
    @JvmName("skckonijlexrkgmx")
    public suspend fun eventTime(`value`: JsonFieldArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventTime = mapped
    }

    /**
     * @param argument The mapping information for the EventTime property of the Event Grid Event.
     */
    @JvmName("tophqydgxyqndyxk")
    public suspend fun eventTime(argument: suspend JsonFieldArgsBuilder.() -> Unit) {
        val toBeMapped = JsonFieldArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.eventTime = mapped
    }

    /**
     * @param value The mapping information for the EventType property of the Event Grid Event.
     */
    @JvmName("kkgygynotvmchscx")
    public suspend fun eventType(`value`: JsonFieldWithDefaultArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventType = mapped
    }

    /**
     * @param argument The mapping information for the EventType property of the Event Grid Event.
     */
    @JvmName("xdlrcheygoajnrsr")
    public suspend fun eventType(argument: suspend JsonFieldWithDefaultArgsBuilder.() -> Unit) {
        val toBeMapped = JsonFieldWithDefaultArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.eventType = mapped
    }

    /**
     * @param value The mapping information for the Id property of the Event Grid Event.
     */
    @JvmName("xleaftassmssrqry")
    public suspend fun id(`value`: JsonFieldArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param argument The mapping information for the Id property of the Event Grid Event.
     */
    @JvmName("gpflwvslbmkefake")
    public suspend fun id(argument: suspend JsonFieldArgsBuilder.() -> Unit) {
        val toBeMapped = JsonFieldArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.id = mapped
    }

    /**
     * @param value Type of the custom mapping
     * Expected value is 'Json'.
     */
    @JvmName("fubuvbhwypnclrni")
    public suspend fun inputSchemaMappingType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputSchemaMappingType = mapped
    }

    /**
     * @param value The mapping information for the Subject property of the Event Grid Event.
     */
    @JvmName("dwbygvuhvereryrk")
    public suspend fun subject(`value`: JsonFieldWithDefaultArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subject = mapped
    }

    /**
     * @param argument The mapping information for the Subject property of the Event Grid Event.
     */
    @JvmName("kdfhgrwnivsybqju")
    public suspend fun subject(argument: suspend JsonFieldWithDefaultArgsBuilder.() -> Unit) {
        val toBeMapped = JsonFieldWithDefaultArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subject = mapped
    }

    /**
     * @param value The mapping information for the Topic property of the Event Grid Event.
     */
    @JvmName("fpadhhsbiowxaxyd")
    public suspend fun topic(`value`: JsonFieldArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topic = mapped
    }

    /**
     * @param argument The mapping information for the Topic property of the Event Grid Event.
     */
    @JvmName("mjbrwtynnceldwom")
    public suspend fun topic(argument: suspend JsonFieldArgsBuilder.() -> Unit) {
        val toBeMapped = JsonFieldArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.topic = mapped
    }

    internal fun build(): JsonInputSchemaMappingArgs = JsonInputSchemaMappingArgs(
        dataVersion = dataVersion,
        eventTime = eventTime,
        eventType = eventType,
        id = id,
        inputSchemaMappingType = inputSchemaMappingType ?: throw
            PulumiNullFieldException("inputSchemaMappingType"),
        subject = subject,
        topic = topic,
    )
}
