@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.ResourceProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property groupIds GroupIds from the private link service resource.
 * @property privateEndpoint The Private Endpoint resource for this Connection.
 * @property privateLinkServiceConnectionState Details about the state of the connection.
 * @property provisioningState Provisioning state of the Private Endpoint Connection.
 */
public data class PrivateEndpointConnectionArgs(
    public val groupIds: Output<List<String>>? = null,
    public val privateEndpoint: Output<PrivateEndpointArgs>? = null,
    public val privateLinkServiceConnectionState: Output<ConnectionStateArgs>? = null,
    public val provisioningState: Output<Either<String, ResourceProvisioningState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.eventgrid.inputs.PrivateEndpointConnectionArgs.builder()
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var groupIds: Output<List<String>>? = null

    private var privateEndpoint: Output<PrivateEndpointArgs>? = null

    private var privateLinkServiceConnectionState: Output<ConnectionStateArgs>? = null

    private var provisioningState: Output<Either<String, ResourceProvisioningState>>? = null

    /**
     * @param value GroupIds from the private link service resource.
     */
    @JvmName("autvwmmslmbckbux")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("msrmtjhubxlbqhrm")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values GroupIds from the private link service resource.
     */
    @JvmName("rvmklrdbfvkkuoui")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value The Private Endpoint resource for this Connection.
     */
    @JvmName("iaiygroquqrlmadm")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value Details about the state of the connection.
     */
    @JvmName("hsnwonwgvpdalqfw")
    public suspend fun privateLinkServiceConnectionState(`value`: Output<ConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("sqfptaeqvpuwkhfh")
    public suspend fun provisioningState(`value`: Output<Either<String, ResourceProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value GroupIds from the private link service resource.
     */
    @JvmName("dujojhnngdpuispk")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values GroupIds from the private link service resource.
     */
    @JvmName("ccbocaqcddcgfbjx")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value The Private Endpoint resource for this Connection.
     */
    @JvmName("dpcdvtxfavetssku")
    public suspend fun privateEndpoint(`value`: PrivateEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument The Private Endpoint resource for this Connection.
     */
    @JvmName("jkecuggyvntebyxh")
    public suspend fun privateEndpoint(argument: suspend PrivateEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value Details about the state of the connection.
     */
    @JvmName("afiighkfdjpcbkma")
    public suspend fun privateLinkServiceConnectionState(`value`: ConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Details about the state of the connection.
     */
    @JvmName("mgmrihxlsclfofgd")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend ConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionStateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("uyvsnklsxwviraav")
    public suspend fun provisioningState(`value`: Either<String, ResourceProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("hmauhrxndhbfmsxp")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("ssesdloynrlayvgm")
    public fun provisioningState(`value`: ResourceProvisioningState) {
        val toBeMapped = Either.ofRight<String, ResourceProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        groupIds = groupIds,
        privateEndpoint = privateEndpoint,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        provisioningState = provisioningState,
    )
}
