@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.RoutingIdentityInfoArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.RoutingIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Routing identity info for topic spaces configuration.
 * @property type
 * @property userAssignedIdentity
 */
public data class RoutingIdentityInfoArgs(
    public val type: Output<Either<String, RoutingIdentityType>>? = null,
    public val userAssignedIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.RoutingIdentityInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.RoutingIdentityInfoArgs =
        com.pulumi.azurenative.eventgrid.inputs.RoutingIdentityInfoArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentity(userAssignedIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoutingIdentityInfoArgs].
 */
@PulumiTagMarker
public class RoutingIdentityInfoArgsBuilder internal constructor() {
    private var type: Output<Either<String, RoutingIdentityType>>? = null

    private var userAssignedIdentity: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("iihfhasfyfhriylj")
    public suspend fun type(`value`: Output<Either<String, RoutingIdentityType>>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("fouovvfonbubnxrc")
    public suspend fun userAssignedIdentity(`value`: Output<String>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value
     */
    @JvmName("cpkankqeeyjqgnxq")
    public suspend fun type(`value`: Either<String, RoutingIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("bsywgjwiggfyhpfc")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RoutingIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("nttbqdaeyhaqiquw")
    public fun type(`value`: RoutingIdentityType) {
        val toBeMapped = Either.ofRight<String, RoutingIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("cbmsjmppvmcrnrms")
    public suspend fun userAssignedIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): RoutingIdentityInfoArgs = RoutingIdentityInfoArgs(
        type = type,
        userAssignedIdentity = userAssignedIdentity,
    )
}
