@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.StaticRoutingEnrichmentArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.StaticRoutingEnrichmentType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Static routing enrichment key.
 * @property valueType Static routing enrichment value type. For e.g. this property value can be 'String'.
 */
public data class StaticRoutingEnrichmentArgs(
    public val key: Output<String>? = null,
    public val valueType: Output<Either<String, StaticRoutingEnrichmentType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.StaticRoutingEnrichmentArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.StaticRoutingEnrichmentArgs =
        com.pulumi.azurenative.eventgrid.inputs.StaticRoutingEnrichmentArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .valueType(
                valueType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [StaticRoutingEnrichmentArgs].
 */
@PulumiTagMarker
public class StaticRoutingEnrichmentArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var valueType: Output<Either<String, StaticRoutingEnrichmentType>>? = null

    /**
     * @param value Static routing enrichment key.
     */
    @JvmName("mlcfcgkofwxkyfmi")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Static routing enrichment value type. For e.g. this property value can be 'String'.
     */
    @JvmName("xoodgtumtsqxqffw")
    public suspend fun valueType(`value`: Output<Either<String, StaticRoutingEnrichmentType>>) {
        this.valueType = value
    }

    /**
     * @param value Static routing enrichment key.
     */
    @JvmName("lskgfepaefarpqxp")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Static routing enrichment value type. For e.g. this property value can be 'String'.
     */
    @JvmName("orvfesmojhxnxjcu")
    public suspend fun valueType(`value`: Either<String, StaticRoutingEnrichmentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.valueType = mapped
    }

    /**
     * @param value Static routing enrichment value type. For e.g. this property value can be 'String'.
     */
    @JvmName("qbjddgcrwuouravb")
    public fun valueType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StaticRoutingEnrichmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.valueType = mapped
    }

    /**
     * @param value Static routing enrichment value type. For e.g. this property value can be 'String'.
     */
    @JvmName("vchvxhnrhqesahnv")
    public fun valueType(`value`: StaticRoutingEnrichmentType) {
        val toBeMapped = Either.ofRight<String, StaticRoutingEnrichmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.valueType = mapped
    }

    internal fun build(): StaticRoutingEnrichmentArgs = StaticRoutingEnrichmentArgs(
        key = key,
        valueType = valueType,
    )
}
