@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.TopicSpacesConfigurationArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.TopicSpacesConfigurationState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of the Topic Spaces Configuration.
 * @property clientAuthentication Client authentication settings for topic spaces configuration.
 * @property maximumClientSessionsPerAuthenticationName The maximum number of sessions per authentication name. The property default value is 1.
 * Min allowed value is 1 and max allowed value is 100.
 * @property maximumSessionExpiryInHours The maximum session expiry in hours. The property default value is 1 hour.
 * Min allowed value is 1 hour and max allowed value is 8 hours.
 * @property routeTopicResourceId Fully qualified Azure Resource Id for the Event Grid Topic to which events will be routed to from TopicSpaces under a namespace.
 * This property should be in the following format '/subscriptions/{subId}/resourcegroups/{resourceGroupName}/providers/microsoft.EventGrid/topics/{topicName}'.
 * This topic should reside in the same region where namespace is located.
 * @property routingEnrichments Routing enrichments for topic spaces configuration
 * @property routingIdentityInfo Routing identity info for topic spaces configuration.
 * @property state Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled.
 */
public data class TopicSpacesConfigurationArgs(
    public val clientAuthentication: Output<ClientAuthenticationSettingsArgs>? = null,
    public val maximumClientSessionsPerAuthenticationName: Output<Int>? = null,
    public val maximumSessionExpiryInHours: Output<Int>? = null,
    public val routeTopicResourceId: Output<String>? = null,
    public val routingEnrichments: Output<RoutingEnrichmentsArgs>? = null,
    public val routingIdentityInfo: Output<RoutingIdentityInfoArgs>? = null,
    public val state: Output<Either<String, TopicSpacesConfigurationState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.TopicSpacesConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.TopicSpacesConfigurationArgs =
        com.pulumi.azurenative.eventgrid.inputs.TopicSpacesConfigurationArgs.builder()
            .clientAuthentication(
                clientAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .maximumClientSessionsPerAuthenticationName(
                maximumClientSessionsPerAuthenticationName?.applyValue({ args0 ->
                    args0
                }),
            )
            .maximumSessionExpiryInHours(maximumSessionExpiryInHours?.applyValue({ args0 -> args0 }))
            .routeTopicResourceId(routeTopicResourceId?.applyValue({ args0 -> args0 }))
            .routingEnrichments(
                routingEnrichments?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .routingIdentityInfo(
                routingIdentityInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TopicSpacesConfigurationArgs].
 */
@PulumiTagMarker
public class TopicSpacesConfigurationArgsBuilder internal constructor() {
    private var clientAuthentication: Output<ClientAuthenticationSettingsArgs>? = null

    private var maximumClientSessionsPerAuthenticationName: Output<Int>? = null

    private var maximumSessionExpiryInHours: Output<Int>? = null

    private var routeTopicResourceId: Output<String>? = null

    private var routingEnrichments: Output<RoutingEnrichmentsArgs>? = null

    private var routingIdentityInfo: Output<RoutingIdentityInfoArgs>? = null

    private var state: Output<Either<String, TopicSpacesConfigurationState>>? = null

    /**
     * @param value Client authentication settings for topic spaces configuration.
     */
    @JvmName("arkqergkbmcuhmuj")
    public suspend fun clientAuthentication(`value`: Output<ClientAuthenticationSettingsArgs>) {
        this.clientAuthentication = value
    }

    /**
     * @param value The maximum number of sessions per authentication name. The property default value is 1.
     * Min allowed value is 1 and max allowed value is 100.
     */
    @JvmName("brqdpfkdfncmfyab")
    public suspend fun maximumClientSessionsPerAuthenticationName(`value`: Output<Int>) {
        this.maximumClientSessionsPerAuthenticationName = value
    }

    /**
     * @param value The maximum session expiry in hours. The property default value is 1 hour.
     * Min allowed value is 1 hour and max allowed value is 8 hours.
     */
    @JvmName("lpoorqexuljeggui")
    public suspend fun maximumSessionExpiryInHours(`value`: Output<Int>) {
        this.maximumSessionExpiryInHours = value
    }

    /**
     * @param value Fully qualified Azure Resource Id for the Event Grid Topic to which events will be routed to from TopicSpaces under a namespace.
     * This property should be in the following format '/subscriptions/{subId}/resourcegroups/{resourceGroupName}/providers/microsoft.EventGrid/topics/{topicName}'.
     * This topic should reside in the same region where namespace is located.
     */
    @JvmName("glxuvtnrinajtfam")
    public suspend fun routeTopicResourceId(`value`: Output<String>) {
        this.routeTopicResourceId = value
    }

    /**
     * @param value Routing enrichments for topic spaces configuration
     */
    @JvmName("rgkttdupbeonvggj")
    public suspend fun routingEnrichments(`value`: Output<RoutingEnrichmentsArgs>) {
        this.routingEnrichments = value
    }

    /**
     * @param value Routing identity info for topic spaces configuration.
     */
    @JvmName("hrjrcdicdettbqxt")
    public suspend fun routingIdentityInfo(`value`: Output<RoutingIdentityInfoArgs>) {
        this.routingIdentityInfo = value
    }

    /**
     * @param value Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled.
     */
    @JvmName("efnkjrnlxsobapli")
    public suspend fun state(`value`: Output<Either<String, TopicSpacesConfigurationState>>) {
        this.state = value
    }

    /**
     * @param value Client authentication settings for topic spaces configuration.
     */
    @JvmName("cvyxgfvtibbyaibv")
    public suspend fun clientAuthentication(`value`: ClientAuthenticationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAuthentication = mapped
    }

    /**
     * @param argument Client authentication settings for topic spaces configuration.
     */
    @JvmName("wwnpdrtawidgvgro")
    public suspend
    fun clientAuthentication(argument: suspend ClientAuthenticationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ClientAuthenticationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clientAuthentication = mapped
    }

    /**
     * @param value The maximum number of sessions per authentication name. The property default value is 1.
     * Min allowed value is 1 and max allowed value is 100.
     */
    @JvmName("uxulvnfxmfssvird")
    public suspend fun maximumClientSessionsPerAuthenticationName(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumClientSessionsPerAuthenticationName = mapped
    }

    /**
     * @param value The maximum session expiry in hours. The property default value is 1 hour.
     * Min allowed value is 1 hour and max allowed value is 8 hours.
     */
    @JvmName("gdeuketalcpfnjop")
    public suspend fun maximumSessionExpiryInHours(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumSessionExpiryInHours = mapped
    }

    /**
     * @param value Fully qualified Azure Resource Id for the Event Grid Topic to which events will be routed to from TopicSpaces under a namespace.
     * This property should be in the following format '/subscriptions/{subId}/resourcegroups/{resourceGroupName}/providers/microsoft.EventGrid/topics/{topicName}'.
     * This topic should reside in the same region where namespace is located.
     */
    @JvmName("bonrxvtkywjphvye")
    public suspend fun routeTopicResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTopicResourceId = mapped
    }

    /**
     * @param value Routing enrichments for topic spaces configuration
     */
    @JvmName("iiqbnjxjifjtrhlv")
    public suspend fun routingEnrichments(`value`: RoutingEnrichmentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingEnrichments = mapped
    }

    /**
     * @param argument Routing enrichments for topic spaces configuration
     */
    @JvmName("ancecbnpviunrpvt")
    public suspend
    fun routingEnrichments(argument: suspend RoutingEnrichmentsArgsBuilder.() -> Unit) {
        val toBeMapped = RoutingEnrichmentsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routingEnrichments = mapped
    }

    /**
     * @param value Routing identity info for topic spaces configuration.
     */
    @JvmName("moekgsehxfolevmw")
    public suspend fun routingIdentityInfo(`value`: RoutingIdentityInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingIdentityInfo = mapped
    }

    /**
     * @param argument Routing identity info for topic spaces configuration.
     */
    @JvmName("bkunyycucqubwqjh")
    public suspend
    fun routingIdentityInfo(argument: suspend RoutingIdentityInfoArgsBuilder.() -> Unit) {
        val toBeMapped = RoutingIdentityInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routingIdentityInfo = mapped
    }

    /**
     * @param value Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled.
     */
    @JvmName("swmikpvlryviqxis")
    public suspend fun state(`value`: Either<String, TopicSpacesConfigurationState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled.
     */
    @JvmName("vshclrpirafgwimd")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TopicSpacesConfigurationState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled.
     */
    @JvmName("lvfvalghyatkioku")
    public fun state(`value`: TopicSpacesConfigurationState) {
        val toBeMapped = Either.ofRight<String, TopicSpacesConfigurationState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): TopicSpacesConfigurationArgs = TopicSpacesConfigurationArgs(
        clientAuthentication = clientAuthentication,
        maximumClientSessionsPerAuthenticationName = maximumClientSessionsPerAuthenticationName,
        maximumSessionExpiryInHours = maximumSessionExpiryInHours,
        routeTopicResourceId = routeTopicResourceId,
        routingEnrichments = routingEnrichments,
        routingIdentityInfo = routingIdentityInfo,
        state = state,
    )
}
